/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.registry;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.MissingResourceException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.registry.AbstractRegistryServlet;
import org.eclipse.dirigible.runtime.registry.DefinitionEnumerator;
import org.eclipse.dirigible.runtime.registry.PathUtils;

public abstract class AbstractRegistryServiceServlet
extends AbstractRegistryServlet {
    private static final long serialVersionUID = -8255379751142002763L;
    private static final Logger logger = Logger.getLogger(AbstractRegistryServiceServlet.class);
    private static final String SERVICES_FOLDER = "ScriptingServices/";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String repositoryPath = "/db/dirigible/registry/public/" + this.getServicesFolder();
        try {
            ICollection collection = this.getRepository(request).getCollection(repositoryPath);
            this.buildList(new DefinitionEnumerator(repositoryPath, collection, this.getFileExtension()).toArrayList(), request, response);
        }
        catch (IllegalArgumentException ex) {
            logger.error(String.valueOf(String.format(this.getRequestProcessingFailedMessage(), repositoryPath)) + ex.getMessage(), (Throwable)ex);
            response.sendError(400, ex.getMessage());
        }
        catch (MissingResourceException ex) {
            logger.error(String.valueOf(String.format(this.getRequestProcessingFailedMessage(), repositoryPath)) + ex.getMessage(), (Throwable)ex);
            response.sendError(204, ex.getMessage());
        }
    }

    protected String getServicesFolder() {
        return SERVICES_FOLDER;
    }

    private void buildList(List<String> jsDefinitions, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        String headingUrl = PathUtils.getHeadingUrl(request, this.getServletMapping());
        JsonArray jsonRootArray = new JsonArray();
        for (String jsDefinition : jsDefinitions) {
            String path = String.valueOf(headingUrl) + jsDefinition;
            JsonObject elementObject = new JsonObject();
            elementObject.addProperty("name", jsDefinition);
            elementObject.addProperty("path", path);
            jsonRootArray.add((JsonElement)elementObject);
        }
        writer.println(new Gson().toJson((JsonElement)jsonRootArray));
        writer.flush();
        writer.close();
    }

    protected abstract String getServletMapping();

    protected abstract String getFileExtension();

    protected abstract String getRequestProcessingFailedMessage();
}

