/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.view;

import java.net.URL;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IFile;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishManager;
import org.eclipse.dirigible.ide.ui.widget.extbrowser.ExtendedBrowser;
import org.eclipse.dirigible.ide.workspace.dual.DirectRenderer;
import org.eclipse.dirigible.ide.workspace.ui.view.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class WebViewerView
extends ViewPart {
    public static String ID = "org.eclipse.dirigible.ide.workspace.ui.view.WebViewerView";
    private static final String PUBLIC = Messages.WebViewerView_PUBLIC;
    private static final String OPEN = Messages.WebViewerView_OPEN;
    private static final String SANDBOX = Messages.WebViewerView_SANDBOX;
    private static final String REFRESH = Messages.WebViewerView_REFRESH;
    private static final String EMPTY_STRING = "";
    private static final URL DIRIGIBLE_REFRESH_ICON_URL = WebViewerView.class.getResource("/resources/icons/refresh.png");
    private static final URL DIRIGIBLE_SANDBOX_ICON_URL = WebViewerView.class.getResource("/resources/icons/sandbox.png");
    private static final URL DIRIGIBLE_OPEN_ICON_URL = WebViewerView.class.getResource("/resources/icons/open.png");
    private final ISelectionListener selectionListener = new SelectionListenerImpl();
    private ExtendedBrowser browser;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Text pageUrlText;
    private boolean isSandbox = CommonParameters.isSandboxEnabled();
    private IFile lastSelectedFile;
    private boolean isContent = false;

    public static void refreshWebViewerViewIfVisible() {
        IWorkbenchPage activePage;
        IViewPart view;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null && (view = (activePage = workbenchWindow.getActivePage()).findView(WebViewerView.class.getName())) != null && view instanceof WebViewerView && activePage.isPartVisible((IWorkbenchPart)view)) {
            ((WebViewerView)view).refresh();
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.attachSelectionListener((IWorkbenchPartSite)site);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        Composite holder = new Composite(parent, 0);
        holder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        holder.setLayout((Layout)new GridLayout(4, false));
        if (CommonParameters.isSandboxEnabled()) {
            this.createSandboxToggleButton(holder);
        }
        this.createRefreshButton(holder);
        this.createUrlAddressField(holder);
        this.browser = new ExtendedBrowser(parent, 0);
        this.browser.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setUrl(EMPTY_STRING);
    }

    private void createSandboxToggleButton(Composite holder) {
        final Button sandboxToggleButton = new Button(holder, 2);
        sandboxToggleButton.setLayoutData((Object)new GridData(131072, 4, false, false));
        sandboxToggleButton.setToolTipText(this.isSandbox ? SANDBOX : PUBLIC);
        sandboxToggleButton.setSelection(this.isSandbox);
        sandboxToggleButton.setImage(this.createImage(DIRIGIBLE_SANDBOX_ICON_URL));
        sandboxToggleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = -6880371869205820154L;

            public void widgetSelected(SelectionEvent e) {
                WebViewerView.this.isSandbox = sandboxToggleButton.getSelection();
                sandboxToggleButton.setToolTipText(WebViewerView.this.isSandbox ? SANDBOX : PUBLIC);
                if (WebViewerView.this.lastSelectedFile != null) {
                    WebViewerView.this.handleElementSelected(WebViewerView.this.lastSelectedFile);
                    WebViewerView.this.refresh();
                }
            }
        });
    }

    private void createRefreshButton(Composite holder) {
        Button refreshButton = new Button(holder, 8);
        refreshButton.setLayoutData((Object)new GridData(131072, 4, false, false));
        refreshButton.setToolTipText(REFRESH);
        refreshButton.setImage(this.createImage(DIRIGIBLE_REFRESH_ICON_URL));
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 5640314767414360517L;

            public void widgetSelected(SelectionEvent e) {
                WebViewerView.this.refresh();
            }
        });
    }

    public void refresh() {
        this.browser.setUrl(this.pageUrlText.getText());
        if (!this.isContent) {
            this.browser.refresh();
        } else {
            this.updateByContent(this.pageUrlText.getText());
        }
        this.firePropertyChange(0);
    }

    private void createUrlAddressField(Composite parent) {
        this.pageUrlText = new Text(parent, 2048);
        this.pageUrlText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.pageUrlText.addTraverseListener(new TraverseListener(){
            private static final long serialVersionUID = 793018001113676818L;

            public void keyTraversed(TraverseEvent e) {
                WebViewerView.this.refresh();
            }
        });
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        this.detachSelectionListener(this.getSite());
        this.browser = null;
        super.dispose();
    }

    private void attachSelectionListener(IWorkbenchPartSite site) {
        if (site == null) {
            return;
        }
        ISelectionService selectionService = this.getSelectionService(site);
        if (selectionService != null) {
            selectionService.addSelectionListener(this.selectionListener);
        }
    }

    private void detachSelectionListener(IWorkbenchPartSite site) {
        if (site == null) {
            return;
        }
        ISelectionService selectionService = this.getSelectionService(site);
        if (selectionService != null) {
            selectionService.removeSelectionListener(this.selectionListener);
        }
    }

    private ISelectionService getSelectionService(IWorkbenchPartSite site) {
        IWorkbenchWindow window = site.getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getSelectionService();
    }

    private void handleElementSelected(Object element) {
        if (element instanceof IFile) {
            IFile file;
            this.lastSelectedFile = file = (IFile)element;
            IPublisher publisher = this.getPublisher(file);
            if (publisher != null) {
                String activePerspectiveId = this.getActivePerspective();
                String endpoint = null;
                if ("debug".equals(activePerspectiveId)) {
                    endpoint = publisher.getDebugEndpoint(file);
                } else {
                    String string = endpoint = this.isSandbox ? publisher.getActivatedEndpoint(file) : publisher.getPublishedEndpoint(file);
                }
                if (endpoint != null) {
                    this.setUrl(endpoint);
                }
            }
        }
    }

    private String getActivePerspective() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        String id = perspective.getId();
        return id;
    }

    private IPublisher getPublisher(IFile file) {
        List publishers = PublishManager.getPublishers();
        for (IPublisher iPublisher : publishers) {
            IPublisher publisher = iPublisher;
            if (!publisher.recognizedFile(file)) continue;
            return publisher;
        }
        return null;
    }

    private Image createImage(URL imageURL) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        return this.resourceManager.createImage(imageDescriptor);
    }

    protected void setUrl(String text) {
        if (text == null || EMPTY_STRING.equals(text)) {
            return;
        }
        try {
            HttpServletRequest request = CommonParameters.getRequest();
            if (request != null) {
                this.updateByUrl(text, request);
            } else {
                this.updateByContent(text);
            }
            this.firePropertyChange(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateByContent(String text) {
        this.pageUrlText.setText(text);
        String content = DirectRenderer.renderContent((String)text);
        this.browser.setContent(content);
        this.isContent = true;
    }

    private void updateByUrl(String text, HttpServletRequest request) {
        String url = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + text;
        this.pageUrlText.setText(url);
        this.browser.setUrl(url);
        this.browser.refresh();
        this.isContent = false;
    }

    private class SelectionListenerImpl
    implements ISelectionListener {
        private SelectionListenerImpl() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                this.selectionChanged((IStructuredSelection)selection);
            }
        }

        private void selectionChanged(IStructuredSelection selection) {
            Object element = selection.getFirstElement();
            if (element != null) {
                WebViewerView.this.handleElementSelected(element);
            }
        }
    }
}

