/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.wizard;

import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlTemplateModel;
import org.eclipse.dirigible.ide.template.ui.html.wizard.Messages;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;

public class HtmlTemplateTargetLocationPage
extends TemplateTargetLocationPage {
    private static final String EXT_HTML = ".html";
    private static final String PAGE_NAME_HTML = "page_name.html";
    private static final String INDEX_HTML = "index.html";
    private static final String SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME = Messages.HtmlTemplateTargetLocationPage_SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME;
    private static final String TARGET_LOCATION = Messages.HtmlTemplateTargetLocationPage_TARGET_LOCATION;
    private static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlTemplateTargetLocationPage";
    private HtmlTemplateModel model;

    protected HtmlTemplateTargetLocationPage(HtmlTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(TARGET_LOCATION);
        this.setDescription(SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME);
    }

    protected void checkPageStatus() {
        if (this.getModel().getTargetLocation() == null || "".equals(this.getModel().getTargetLocation())) {
            this.setPageComplete(false);
            return;
        }
        if (this.getModel().getFileName() == null || "".equals(this.getModel().getFileName())) {
            this.setPageComplete(false);
            return;
        }
        IValidationStatus status = this.model.validateLocation();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getDefaultFileName(String preset) {
        if (this.getModel().getFileName() == null || "".equals(this.getModel().getFileName())) {
            String pageName = PAGE_NAME_HTML;
            if (this.model.getTemplate().getLocation().endsWith(INDEX_HTML)) {
                pageName = INDEX_HTML;
            }
            return pageName;
        }
        return preset == null ? this.getModel().getFileName() : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + EXT_HTML;
    }

    protected boolean isForcedFileName() {
        return true;
    }

    protected String getArtifactContainerName() {
        return "WebContent";
    }
}

