/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.layout.horizontal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.AbstractSequenceLayout;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;

public class LostMessageEndHorizontalLayoutHelper {
    private final Map<LostMessageEnd, Message> lostMessages = Maps.newHashMap();
    private final Multimap<Lifeline, LostMessageEnd> lostSources = HashMultimap.create();
    private final Multimap<Lifeline, LostMessageEnd> lostTargets = HashMultimap.create();
    private Map<LostMessageEnd, Operand> operands = Maps.newHashMap();
    private Multimap<Operand, LostMessageEnd> operands2lostEnds = HashMultimap.create();
    private Set<LostMessageEnd> diagramLostEnds = Sets.newHashSet();
    private SequenceDiagram sequenceDiagram;
    private Set<LostMessageEnd> unconnectedLostEnds = Sets.newHashSet();

    public LostMessageEndHorizontalLayoutHelper(SequenceDiagram diagram) {
        this.sequenceDiagram = diagram;
    }

    public void populateLostMessageEnds() {
        for (Message msg : this.sequenceDiagram.getAllMessages()) {
            this.populateLostEnds(msg);
        }
        this.registerUnconnectedLostEnds();
    }

    private void registerUnconnectedLostEnds() {
        Predicate unConnectedEnds = Predicates.not((Predicate)Predicates.in(this.lostMessages.keySet()));
        for (LostMessageEnd lme : Iterables.filter(this.sequenceDiagram.getAllLostMessageEnds(), (Predicate)unConnectedEnds)) {
            ISequenceEvent ise;
            EdgeTarget sourceNode;
            ISequenceEvent ise2;
            this.unconnectedLostEnds.add(lme);
            if (!(lme.getNotationNode().getElement() instanceof EdgeTarget)) continue;
            EdgeTarget targetNode = this.getKnownTargetNode(lme);
            if (targetNode != null && (ise2 = this.getISequenceEvent(targetNode)) != null && ise2.getLifeline().some()) {
                this.lostSources.put((Object)((Lifeline)ise2.getLifeline().get()), (Object)lme);
                Option<Operand> parentOperand = ise2.getParentOperand();
                if (parentOperand.some()) {
                    this.operands.put(lme, (Operand)parentOperand.get());
                    this.operands2lostEnds.put((Object)((Operand)parentOperand.get()), (Object)lme);
                } else {
                    this.diagramLostEnds.add(lme);
                }
            }
            if ((sourceNode = this.getKnownSourceNode(lme)) == null || (ise = this.getISequenceEvent(sourceNode)) == null || !ise.getLifeline().some()) continue;
            this.lostTargets.put((Object)((Lifeline)ise.getLifeline().get()), (Object)lme);
            Option<Operand> parentOperand = ise.getParentOperand();
            if (parentOperand.some()) {
                this.operands.put(lme, (Operand)parentOperand.get());
                this.operands2lostEnds.put((Object)((Operand)parentOperand.get()), (Object)lme);
                continue;
            }
            this.diagramLostEnds.add(lme);
        }
    }

    private void populateLostEnds(Message msg) {
        ISequenceNode sourceElement = msg.getSourceElement();
        ISequenceNode targetElement = msg.getTargetElement();
        Option<Operand> parentOperand = msg.getParentOperand();
        if (sourceElement != null && targetElement != null) {
            Option<Lifeline> sourceLifeline = sourceElement.getLifeline();
            Option<Lifeline> targetLifeline = targetElement.getLifeline();
            if (sourceElement instanceof LostMessageEnd && targetLifeline.some()) {
                LostMessageEnd sourceLME = (LostMessageEnd)sourceElement;
                this.lostSources.put((Object)((Lifeline)targetLifeline.get()), (Object)sourceLME);
                this.lostMessages.put(sourceLME, msg);
                if (parentOperand.some()) {
                    this.operands.put(sourceLME, (Operand)parentOperand.get());
                    this.operands2lostEnds.put((Object)((Operand)parentOperand.get()), (Object)sourceLME);
                } else {
                    this.diagramLostEnds.add(sourceLME);
                }
            } else if (targetElement instanceof LostMessageEnd && sourceLifeline.some()) {
                LostMessageEnd targetLME = (LostMessageEnd)targetElement;
                this.lostTargets.put((Object)((Lifeline)sourceLifeline.get()), (Object)targetLME);
                this.lostMessages.put(targetLME, msg);
                if (parentOperand.some()) {
                    this.operands.put(targetLME, (Operand)parentOperand.get());
                    this.operands2lostEnds.put((Object)((Operand)parentOperand.get()), (Object)targetLME);
                } else {
                    this.diagramLostEnds.add(targetLME);
                }
            }
        }
    }

    public Map<LostMessageEnd, Integer> computeLostMessageEndDeltaWithLifeline(boolean pack) {
        HashMap deltas = Maps.newHashMap();
        for (Lifeline lifeline : this.sequenceDiagram.getAllLifelines()) {
            Message.Kind kind;
            int lifelineX = lifeline.getProperLogicalBounds().x;
            HashMap maxOpSourceDeltas = Maps.newHashMap();
            int maxLifelineSourceDelta = 0;
            for (LostMessageEnd lostSource : this.lostSources.get((Object)lifeline)) {
                Rectangle rectangle = lostSource.getProperLogicalBounds().getCopy();
                int delta = rectangle.x - lifelineX;
                if (pack || AbstractSequenceLayout.createdFromTool(lostSource) || AbstractSequenceLayout.createdFromExternalChange(lostSource)) {
                    delta = this.getFoundEndPackedX(lostSource, lifeline, lifelineX, rectangle.width);
                }
                deltas.put(lostSource, delta);
                if (this.operands.containsKey(lostSource)) {
                    Operand op = this.operands.get(lostSource);
                    int opMax = 0;
                    if (maxOpSourceDeltas.containsKey(op)) {
                        opMax = (Integer)maxOpSourceDeltas.get(op);
                    }
                    opMax = Math.min(opMax, delta);
                    maxOpSourceDeltas.put(op, opMax);
                    continue;
                }
                kind = this.getMessageKind(lostSource);
                if (Message.Kind.CREATION.equals((Object)kind) || Message.Kind.DESTRUCTION.equals((Object)kind)) continue;
                maxLifelineSourceDelta = Math.min(maxLifelineSourceDelta, delta);
            }
            HashMap maxOpTargetDeltas = Maps.newHashMap();
            int maxLifelineTargetDelta = 0;
            for (LostMessageEnd lostMessageEnd : this.lostTargets.get((Object)lifeline)) {
                Rectangle bounds = lostMessageEnd.getProperLogicalBounds().getCopy();
                int delta = bounds.x - lifelineX;
                if (pack || AbstractSequenceLayout.createdFromTool(lostMessageEnd) || AbstractSequenceLayout.createdFromExternalChange(lostMessageEnd)) {
                    ISequenceEvent sourceEvent;
                    delta = 60;
                    if (this.lostMessages.containsKey(lostMessageEnd)) {
                        Message message = this.lostMessages.get(lostMessageEnd);
                        delta += message.getSourceElement().getProperLogicalBounds().right() - lifelineX;
                    } else if (this.unconnectedLostEnds.contains(lostMessageEnd) && (sourceEvent = this.getISequenceEvent(this.getKnownSourceNode(lostMessageEnd))) != null) {
                        delta += sourceEvent.getProperLogicalBounds().right() - lifelineX;
                    }
                }
                deltas.put(lostMessageEnd, delta);
                if (this.operands.containsKey(lostMessageEnd)) {
                    Operand op = this.operands.get(lostMessageEnd);
                    int opMax = 0;
                    if (maxOpTargetDeltas.containsKey(op)) {
                        opMax = (Integer)maxOpTargetDeltas.get(op);
                    }
                    opMax = Math.max(opMax, delta);
                    maxOpTargetDeltas.put(op, opMax);
                    continue;
                }
                maxLifelineTargetDelta = Math.max(maxLifelineTargetDelta, delta);
            }
            if (!pack) continue;
            for (Map.Entry entry : maxOpSourceDeltas.entrySet()) {
                Integer maxSourceDelta = (Integer)entry.getValue();
                for (LostMessageEnd source : Iterables.filter((Iterable)this.operands2lostEnds.get((Object)((Operand)entry.getKey())), (Predicate)Predicates.in((Collection)this.lostSources.get((Object)lifeline)))) {
                    deltas.put(source, maxSourceDelta);
                }
            }
            for (LostMessageEnd lostMessageEnd : Iterables.filter((Iterable)this.lostSources.get((Object)lifeline), (Predicate)Predicates.not((Predicate)Predicates.in(this.operands.keySet())))) {
                kind = this.getMessageKind(lostMessageEnd);
                if (Message.Kind.CREATION.equals((Object)kind) || Message.Kind.DESTRUCTION.equals((Object)kind)) continue;
                deltas.put(lostMessageEnd, maxLifelineSourceDelta);
            }
            for (Map.Entry entry : maxOpTargetDeltas.entrySet()) {
                Integer maxTargetDelta = (Integer)entry.getValue();
                for (LostMessageEnd target : Iterables.filter((Iterable)this.operands2lostEnds.get((Object)((Operand)entry.getKey())), (Predicate)Predicates.in((Collection)this.lostTargets.get((Object)lifeline)))) {
                    deltas.put(target, maxTargetDelta);
                }
            }
            for (LostMessageEnd lostMessageEnd : Iterables.filter((Iterable)this.lostTargets.get((Object)lifeline), (Predicate)Predicates.not((Predicate)Predicates.in(this.operands.keySet())))) {
                deltas.put(lostMessageEnd, maxLifelineTargetDelta);
            }
        }
        return deltas;
    }

    private int getFoundEndPackedX(LostMessageEnd lostSourceEnd, Lifeline lifeline, int lifelineX, int lostEndWidth) {
        int refX = lifelineX;
        Message.Kind kind = this.getMessageKind(lostSourceEnd);
        if (Message.Kind.CREATION.equals((Object)kind) && lifeline.getInstanceRole() != null) {
            refX = lifeline.getInstanceRole().getProperLogicalBounds().x;
        } else if (Message.Kind.DESTRUCTION.equals((Object)kind) && lifeline.getEndOfLife().some()) {
            refX = ((EndOfLife)lifeline.getEndOfLife().get()).getProperLogicalBounds().x;
        }
        return refX - lifelineX - 60 - lostEndWidth;
    }

    public int getLeftGap(Lifeline lifeline, Range zone, Map<LostMessageEnd, Integer> lostEndsDelta) {
        int foundEndsGap = this.getLostMessageEndsGap(lifeline, this.lostSources, zone, lostEndsDelta, true);
        int lostMessageEndsGap = this.getLostMessageEndsGap(lifeline, this.lostTargets, zone, lostEndsDelta, true);
        return Math.max(lostMessageEndsGap, foundEndsGap);
    }

    public int getRightEndsGap(Lifeline lifeline, Range zone, Map<LostMessageEnd, Integer> lostEndsDelta) {
        int lostMessageEndsGap = this.getLostMessageEndsGap(lifeline, this.lostTargets, zone, lostEndsDelta, false);
        int foundEndsGap = this.getLostMessageEndsGap(lifeline, this.lostSources, zone, lostEndsDelta, false);
        return Math.max(lostMessageEndsGap, foundEndsGap);
    }

    private EdgeTarget getKnownSourceNode(LostMessageEnd lme) {
        EdgeTarget sourceNode = null;
        EdgeTarget dde = (EdgeTarget)lme.getNotationNode().getElement();
        Iterable incomingEdges = Iterables.filter((Iterable)dde.getIncomingEdges(), Message.viewpointElementPredicate());
        if (!Iterables.isEmpty((Iterable)incomingEdges)) {
            DEdge msg = (DEdge)incomingEdges.iterator().next();
            sourceNode = msg.getSourceNode();
        }
        return sourceNode;
    }

    private EdgeTarget getKnownTargetNode(LostMessageEnd lme) {
        EdgeTarget targetNode = null;
        EdgeTarget dde = (EdgeTarget)lme.getNotationNode().getElement();
        Iterable outgoingEdges = Iterables.filter((Iterable)dde.getOutgoingEdges(), Message.viewpointElementPredicate());
        if (!Iterables.isEmpty((Iterable)outgoingEdges)) {
            DEdge msg = (DEdge)outgoingEdges.iterator().next();
            targetNode = msg.getTargetNode();
        }
        return targetNode;
    }

    private ISequenceEvent getISequenceEvent(EdgeTarget lostNode) {
        ISequenceEvent correspondingEvent = null;
        ArrayList knownEnds = Lists.newArrayList();
        knownEnds.addAll(this.sequenceDiagram.getAllLifelines());
        knownEnds.addAll(this.sequenceDiagram.getAllExecutions());
        for (ISequenceEvent ise : knownEnds) {
            if (ise.getNotationView() == null || lostNode == null || !lostNode.equals(ise.getNotationView().getElement())) continue;
            correspondingEvent = ise;
            break;
        }
        if (correspondingEvent == null) {
            EObject eContainer = lostNode.eContainer();
            for (ISequenceEvent ise : knownEnds) {
                if (ise.getNotationView() == null || eContainer == null || !eContainer.equals(ise.getNotationView().getElement())) continue;
                correspondingEvent = ise;
            }
        }
        return correspondingEvent;
    }

    private Message.Kind getMessageKind(LostMessageEnd lostSourceEnd) {
        EdgeTarget dde;
        Message.Kind kind = Message.Kind.BASIC;
        Message message = this.lostMessages.get(lostSourceEnd);
        if (message != null) {
            kind = message.getKind();
        } else if (this.unconnectedLostEnds.contains(lostSourceEnd) && lostSourceEnd.getNotationNode().getElement() instanceof EdgeTarget && !(dde = (EdgeTarget)lostSourceEnd.getNotationNode().getElement()).getOutgoingEdges().isEmpty()) {
            kind = (Message.Kind)((Object)Message.VIEWPOINT_MESSAGE_KIND.apply((Object)((DEdge)dde.getOutgoingEdges().iterator().next())));
        }
        return kind;
    }

    private int getLostMessageEndsGap(Lifeline lifeline, Multimap<Lifeline, LostMessageEnd> lostEnds, Range zone, Map<LostMessageEnd, Integer> lostEndsDelta, boolean revertDelta) {
        int gap = 0;
        if (lostEnds.containsKey((Object)lifeline)) {
            int maxLostEndWidth = 0;
            int maxDelta = 0;
            int frameBorder = 0;
            for (LostMessageEnd lme : lostEnds.get((Object)lifeline)) {
                if (zone != null && (!this.lostMessages.containsKey(lme) || !zone.includesAtLeastOneBound(this.lostMessages.get(lme).getVerticalRange()))) continue;
                int delta = lostEndsDelta.get(lme);
                if ((maxDelta = Math.max(maxDelta, revertDelta ? -delta : delta)) <= 0) continue;
                frameBorder = 10;
                maxLostEndWidth = Math.max(maxLostEndWidth, lme.getProperLogicalBounds().width);
            }
            gap = maxDelta + maxLostEndWidth + frameBorder;
        }
        return gap;
    }

    public void dispose() {
        this.operands.clear();
        this.operands2lostEnds.clear();
        this.diagramLostEnds.clear();
        this.lostMessages.clear();
        this.lostSources.clear();
        this.lostTargets.clear();
        this.unconnectedLostEnds.clear();
    }

    public Map<LostMessageEnd, Rectangle> computeLostMessageEndsHorizontalBounds(Map<InstanceRole, Rectangle> irMoves, Map<LostMessageEnd, Integer> lostEndsDelta) {
        HashMap lostMessageEndMoves = Maps.newHashMap();
        for (Lifeline lifeline : this.sequenceDiagram.getAllLifelines()) {
            int newLifelineX = this.getNewLifelineX(lifeline, irMoves);
            for (LostMessageEnd lostSource : Iterables.concat((Iterable)this.lostSources.get((Object)lifeline), (Iterable)this.lostTargets.get((Object)lifeline))) {
                int deltaWithLifeline = lostEndsDelta.get(lostSource);
                Rectangle bounds = lostSource.getProperLogicalBounds().getCopy();
                bounds.x = newLifelineX + deltaWithLifeline;
                lostMessageEndMoves.put(lostSource, bounds);
            }
        }
        return lostMessageEndMoves;
    }

    private int getNewLifelineX(Lifeline lifeline, Map<InstanceRole, Rectangle> irMoves) {
        int lifelineOldX = lifeline.getProperLogicalBounds().x;
        InstanceRole instanceRole = lifeline.getInstanceRole();
        int deltaX = 0;
        if (instanceRole != null && irMoves.containsKey(instanceRole)) {
            Rectangle irBounds = instanceRole.getProperLogicalBounds().getCopy();
            Rectangle irFutureBounds = irMoves.get(instanceRole);
            deltaX = irFutureBounds.x - irBounds.x;
        }
        return lifelineOldX + deltaX;
    }
}

