/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.dialect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.description.contribution.ContributionPoint;
import org.eclipse.sirius.table.tools.internal.Messages;

public class ContributionTrakingIdentifier
implements Function<EObject, Object> {
    private final Function<EObject, String> pathFunction;
    private Supplier<EObject> edSupplier;
    private Supplier<Iterable<ContributionPoint>> cpSupplier;

    public ContributionTrakingIdentifier(Supplier<EObject> edSupplier, Supplier<Iterable<ContributionPoint>> cpSupplier, Function<EObject, String> pathFunction) {
        this.edSupplier = (Supplier)Preconditions.checkNotNull(edSupplier);
        this.cpSupplier = (Supplier)Preconditions.checkNotNull(cpSupplier);
        this.pathFunction = (Function)Preconditions.checkNotNull(pathFunction);
    }

    public Object apply(EObject from) {
        String currentURI = (String)this.pathFunction.apply((Object)from);
        if (this.isInContributionScope(from)) {
            ContributionPoint cp = this.findMostSpecificContributionPoint(from, (EObject)this.edSupplier.get(), (Iterable)this.cpSupplier.get());
            if (cp != null) {
                String parentURI = (String)this.pathFunction.apply((Object)cp.getContributed());
                String relativeURI = currentURI.replace(parentURI, "");
                return String.valueOf(cp.getOrigin()) + relativeURI;
            }
            throw new RuntimeException(Messages.ContributionTrakingIdentifier_ElementWithoutMatchingData);
        }
        return currentURI;
    }

    private boolean isInContributionScope(EObject from) {
        EObject scopeRoot = (EObject)this.edSupplier.get();
        return scopeRoot != null && (from == scopeRoot || EcoreUtil.isAncestor((EObject)scopeRoot, (EObject)from));
    }

    private ContributionPoint findMostSpecificContributionPoint(EObject obj, EObject root, Iterable<ContributionPoint> points) {
        EObject current = obj;
        while (current != root.eContainer()) {
            ContributionPoint cp = this.findContributionPoint(current, points);
            if (cp != null) {
                return cp;
            }
            current = current.eContainer();
        }
        return null;
    }

    private ContributionPoint findContributionPoint(EObject from, Iterable<ContributionPoint> contributionPoints) {
        for (ContributionPoint cp : contributionPoints) {
            if (cp.getContributed() != from) continue;
            return cp;
        }
        return null;
    }
}

