/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.newmodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.ui.tools.internal.wizards.newmodel.CreateEMFModelWizardDataModel;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NameAndLocationWizardPage
extends WizardNewFileCreationPage
implements PropertyChangeListener {
    public static final String XMI_DEFAULT_EXTENSION = "xmi";
    private CreateEMFModelWizardDataModel dataModel;

    public NameAndLocationWizardPage(IStructuredSelection selection, CreateEMFModelWizardDataModel dataModel) {
        super("NameAndLocationWizardPage", selection);
        this.dataModel = dataModel;
        this.setTitle(Messages.NameAndLocationWizardPage_title);
        this.setDescription(Messages.NameAndLocationWizardPage_description);
    }

    public IFile getModelFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedPackage".equals(evt.getPropertyName())) {
            this.setFileName(this.genDefaultFullFileName());
        }
    }

    protected boolean validatePage() {
        boolean isValid = false;
        if (super.validatePage()) {
            String extension = new Path(this.getFileName()).getFileExtension();
            if (extension == null) {
                this.setErrorMessage(Messages.NameAndLocationWizardPage_errorMessage);
                isValid = false;
            } else {
                isValid = true;
            }
        }
        return isValid;
    }

    private String genDefaultFullFileName() {
        return String.valueOf(this.genDefaultFileName()) + "." + this.genDefaultExtensionName();
    }

    private String genDefaultFileName() {
        String defaultFileName = Messages.CreateEMFModelWizard_modelNamePrefix;
        EPackage ePackage = this.dataModel.getSelectedPackage();
        if (ePackage != null) {
            String ePackageName = ePackage.getName();
            defaultFileName = String.valueOf(defaultFileName) + Character.toUpperCase(ePackageName.charAt(0)) + ePackageName.substring(1);
        }
        return defaultFileName;
    }

    private String genDefaultExtensionName() {
        String defaultExtensionName = null;
        EPackage ePackage = this.dataModel.getSelectedPackage();
        defaultExtensionName = ePackage != null ? ePackage.getName() : XMI_DEFAULT_EXTENSION;
        return defaultExtensionName;
    }
}

