/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.contribution;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.internal.contribution.ReferenceResolver;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.description.contribution.ComputedEObjectReference;
import org.eclipse.sirius.description.contribution.DirectEObjectReference;
import org.eclipse.sirius.description.contribution.EObjectReference;
import org.eclipse.sirius.description.contribution.util.ContributionSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class SiriusReferenceResolver
implements ReferenceResolver {
    private static final String SOURCES_VARIABLE_NAME = "sources";
    private final IInterpreter interpreter;

    public SiriusReferenceResolver(IInterpreter interpreter) {
        this.interpreter = (IInterpreter)Preconditions.checkNotNull((Object)interpreter);
    }

    @Override
    public Option<EObject> resolve(EObjectReference ref, final Map<String, Object> context) {
        Preconditions.checkNotNull((Object)ref);
        ContributionSwitch<EObject> contributionSwitch = new ContributionSwitch<EObject>(){

            @Override
            public EObject caseDirectEObjectReference(DirectEObjectReference directRef) {
                return SiriusReferenceResolver.this.resolveDirectReference(directRef);
            }

            @Override
            public EObject caseComputedEObjectReference(ComputedEObjectReference computedRef) {
                return SiriusReferenceResolver.this.resolveComputedReference(computedRef, context);
            }
        };
        EObject result = (EObject)contributionSwitch.doSwitch(ref);
        return Options.fromNullable((Object)result);
    }

    private EObject resolveDirectReference(DirectEObjectReference directRef) {
        return directRef.getValue();
    }

    private EObject resolveComputedReference(ComputedEObjectReference computedRef, Map<String, Object> context) {
        EObject result = null;
        String expr = computedRef.getValueExpression();
        if (expr != null && this.interpreter.provides(expr) && context.get("self") instanceof EObject) {
            try {
                try {
                    this.interpreter.setVariable(SOURCES_VARIABLE_NAME, context.get(SOURCES_VARIABLE_NAME));
                    result = this.interpreter.evaluateEObject((EObject)context.get("self"), expr);
                }
                catch (EvaluationException evaluationException) {
                    this.interpreter.unSetVariable(SOURCES_VARIABLE_NAME);
                }
            }
            finally {
                this.interpreter.unSetVariable(SOURCES_VARIABLE_NAME);
            }
        }
        return result;
    }
}

