/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fx.internal.projects;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.VBoxBuilder;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.ESWorkspace;
import org.eclipse.emf.emfstore.client.observer.ESLoginObserver;
import org.eclipse.emf.emfstore.client.observer.ESLogoutObserver;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.fx.internal.projects.Activator;
import org.eclipse.emf.emfstore.fx.internal.projects.LoginStage;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.server.EMFStoreController;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public final class ESRemoteProjectTreeCell
extends TreeCell<Object> {
    private static List<String> localURLs = Arrays.asList("localhost", "127.0.0.1");
    private final ContextMenu remoteProjectMenu = new ContextMenu();
    private final ContextMenu serverMenu = new ContextMenu();
    private final BooleanProperty loggedIn = new SimpleBooleanProperty(false);

    public ESRemoteProjectTreeCell() {
        MenuItem addServerMenuItem = new MenuItem();
        ImageView image = new ImageView(Activator.getContext().getBundle().getResource("icons/server_add.png").toExternalForm());
        addServerMenuItem.setGraphic((Node)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_LEFT).children(new Node[]{image, new Label("Add Server")})).build());
        this.remoteProjectMenu.getItems().add((Object)addServerMenuItem);
        this.serverMenu.getItems().add((Object)addServerMenuItem);
        MenuItem addMenuItem = new MenuItem();
        image = new ImageView(Activator.getContext().getBundle().getResource("icons/checkout.png").toExternalForm());
        addMenuItem.setGraphic((Node)new HBox(new Node[]{image, new Label("Checkout")}));
        this.remoteProjectMenu.getItems().add((Object)addMenuItem);
        addMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ESRemoteProject remoteProject = (ESRemoteProject)ESRemoteProjectTreeCell.this.getTreeItem().getValue();
                CheckoutNameStage stage = new CheckoutNameStage();
                stage.showAndWait();
                if (stage.result == null) {
                    return;
                }
                try {
                    remoteProject.checkout(stage.result, remoteProject.getServer().getLastUsersession(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (ESException e) {
                    ESRemoteProjectTreeCell.this.showError((Exception)((Object)e));
                }
            }
        });
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)new ESLoginObserver(){

            public void loginCompleted(ESUsersession session) {
                if (!ESRemoteProjectTreeCell.this.getItem().equals(session.getServer())) {
                    return;
                }
                ESRemoteProjectTreeCell.this.loggedIn.set(true);
            }
        });
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)new ESLogoutObserver(){

            public void logoutCompleted(ESUsersession session) {
                if (!ESRemoteProjectTreeCell.this.getItem().equals(session.getServer())) {
                    return;
                }
                ESRemoteProjectTreeCell.this.loggedIn.set(false);
            }
        });
    }

    private void showError(Exception e) {
        Stage errorStage = new Stage();
        errorStage.initModality(Modality.WINDOW_MODAL);
        errorStage.setTitle("Error");
        errorStage.setScene(new Scene((Parent)((VBoxBuilder)VBoxBuilder.create().children(new Node[]{new Label(e.getMessage())})).build()));
        errorStage.showAndWait();
    }

    public void updateItem(Object item, boolean empty) {
        super.updateItem(item, empty);
        if (item != null) {
            String cellText = null;
            ImageView graphics = null;
            if (ESWorkspace.class.isInstance(item)) {
                cellText = "Known Server";
            } else if (ESRemoteProject.class.isInstance(item)) {
                cellText = ((ESRemoteProject)ESRemoteProject.class.cast(item)).getProjectName();
                graphics = new ImageView(Activator.getContext().getBundle().getResource("icons/remoteProject.png").toExternalForm());
                this.setContextMenu(this.remoteProjectMenu);
            } else if (ESServer.class.isInstance(item)) {
                ImageView image;
                ESServer server = (ESServer)item;
                cellText = String.valueOf(server.getName()) + "(" + server.getURL() + ":" + server.getPort() + ")";
                graphics = new ImageView(Activator.getContext().getBundle().getResource("icons/server.png").toExternalForm());
                if (localURLs.contains(server.getURL()) && EMFStoreController.getInstance() == null) {
                    final MenuItem startServerItem = new MenuItem();
                    image = new ImageView(Activator.getContext().getBundle().getResource("icons/server_go.png").toExternalForm());
                    startServerItem.setGraphic((Node)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_LEFT).children(new Node[]{image, new Label("Start Server")})).build());
                    this.serverMenu.getItems().add(0, (Object)startServerItem);
                    startServerItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent arg0) {
                            try {
                                EMFStoreController.runAsNewThread();
                                startServerItem.setVisible(false);
                            }
                            catch (FatalESException ex) {
                                ESRemoteProjectTreeCell.this.showError((Exception)((Object)ex));
                            }
                        }
                    });
                }
                MenuItem logInItem = new MenuItem();
                image = new ImageView(Activator.getContext().getBundle().getResource("icons/logIn.png").toExternalForm());
                logInItem.setGraphic((Node)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_LEFT).children(new Node[]{image, new Label("Login")})).build());
                this.serverMenu.getItems().add((Object)logInItem);
                logInItem.setOnAction((EventHandler)new LoginHandler());
                logInItem.visibleProperty().bind((ObservableValue)this.loggedIn.not());
                MenuItem logOutItem = new MenuItem();
                image = new ImageView(Activator.getContext().getBundle().getResource("icons/logOut.png").toExternalForm());
                logOutItem.setGraphic((Node)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_LEFT).children(new Node[]{image, new Label("Logout")})).build());
                this.serverMenu.getItems().add((Object)logOutItem);
                logOutItem.setOnAction((EventHandler)new LogoutHandler());
                logOutItem.visibleProperty().bind((ObservableValue)this.loggedIn);
                if (server.getLastUsersession() != null) {
                    this.loggedIn.set(server.getLastUsersession().isLoggedIn());
                }
                this.setContextMenu(this.serverMenu);
            }
            this.setGraphic((Node)graphics);
            this.setText(cellText);
        }
    }

    private class CheckoutNameStage
    extends Stage {
        private String result;

        public CheckoutNameStage() {
            this.initModality(Modality.WINDOW_MODAL);
            this.setTitle("Enter Name for LocalProject");
            final TextField tf = new TextField();
            Button button = new Button("Create");
            button.setMaxWidth(Double.MAX_VALUE);
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    CheckoutNameStage.this.result = tf.getText();
                    CheckoutNameStage.this.close();
                }
            });
            this.setScene(new Scene((Parent)((VBoxBuilder)VBoxBuilder.create().children(new Node[]{tf, button})).build()));
        }
    }

    private class LoginHandler
    implements EventHandler<ActionEvent> {
        private LoginHandler() {
        }

        public void handle(ActionEvent t) {
            ESServer server = (ESServer)ESRemoteProjectTreeCell.this.getTreeItem().getValue();
            String password = null;
            String user = null;
            if (server.getLastUsersession() != null) {
                password = server.getLastUsersession().getPassword();
                user = server.getLastUsersession().getUsername();
            }
            if (password == null || password.isEmpty() || user == null || user.isEmpty()) {
                LoginStage stage = new LoginStage(server.getLastUsersession());
                stage.showAndWait();
                if (stage.getPassword() == null) {
                    return;
                }
                user = stage.getName();
                password = stage.getPassword();
                try {
                    ESUsersession login = server.login(user, password);
                    login.setSavePassword(stage.isSavePassword());
                }
                catch (ESException e) {
                    ESRemoteProjectTreeCell.this.showError((Exception)((Object)e));
                }
            } else {
                try {
                    server.getLastUsersession().refresh();
                }
                catch (ESException e) {
                    ESRemoteProjectTreeCell.this.showError((Exception)((Object)e));
                }
            }
        }
    }

    private class LogoutHandler
    implements EventHandler<ActionEvent> {
        private LogoutHandler() {
        }

        public void handle(ActionEvent t) {
            ESServer server = (ESServer)ESRemoteProjectTreeCell.this.getTreeItem().getValue();
            try {
                server.getLastUsersession().logout();
            }
            catch (ESException e) {
                ESRemoteProjectTreeCell.this.showError((Exception)((Object)e));
            }
        }
    }
}

