/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ECPFocusCellDrawHighlighter;
import org.eclipse.emf.ecp.edit.internal.swt.controls.TableViewerColumnBuilder;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.swt.table.ButtonBarBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTCustomization;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableViewerComposite
extends Composite {
    private static final String RESIZABLE = "resizable";
    private static final String WEIGHT = "weight";
    private static final String MIN_WIDTH = "min_width";
    private final EMFDataBindingContext emfDatabindingContext = new EMFDataBindingContext();
    private TableViewer tableViewer;
    private Optional<List<Control>> validationControls;

    TableViewerComposite(Composite parent, int style, Object inputObject, TableViewerSWTCustomization customization, IObservableValue title, IObservableValue tooltip) {
        super(parent, style);
        this.renderControl(this, customization, inputObject, this.emfDatabindingContext, title, tooltip);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Optional<List<Control>> getValidationControls() {
        return this.validationControls;
    }

    private void renderControl(Composite parent, TableViewerSWTCustomization customization, Object inputObject, EMFDataBindingContext emfDataBindingContext, IObservableValue title, IObservableValue tooltip) {
        customization.createCompositeLayout(parent);
        Optional<Label> titleLabel = customization.getTitleLabel();
        if (titleLabel.isPresent()) {
            TableViewerComposite.initTitleLabel((Label)titleLabel.get(), title, tooltip, this.emfDatabindingContext);
        }
        this.validationControls = customization.getValidationControls();
        Composite viewerComposite = customization.getViewerComposite();
        this.tableViewer = customization.createTableViewer(viewerComposite);
        Optional<Composite> buttonComposite = customization.getButtonComposite();
        if (buttonComposite.isPresent()) {
            TableViewerComposite.initButtonComposite((Composite)buttonComposite.get(), customization, this.tableViewer);
        }
        TableViewerComposite.enableTooltipSupport(this.tableViewer);
        TableViewerComposite.enableEditingSupport(this.tableViewer);
        Optional<ViewerComparator> comparator = customization.getComparator();
        if (comparator.isPresent()) {
            this.tableViewer.setComparator((ViewerComparator)comparator.get());
        }
        this.tableViewer.setContentProvider(customization.createContentProvider());
        TableViewerComposite.addColumns(customization, this.tableViewer, emfDataBindingContext);
        this.tableViewer.setInput(inputObject);
        TableColumnLayout layout = new TableColumnLayout();
        viewerComposite.setLayout((Layout)layout);
        int i = 0;
        while (i < this.tableViewer.getTable().getColumns().length) {
            TableColumn tableColumn = this.tableViewer.getTable().getColumns()[i];
            boolean storedIsResizable = (Boolean)tableColumn.getData(RESIZABLE);
            Integer storedWeight = (Integer)tableColumn.getData(WEIGHT);
            Integer storedMinWidth = (Integer)tableColumn.getData(MIN_WIDTH);
            if (storedWeight == -1) {
                layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnPixelData(storedMinWidth.intValue(), storedIsResizable));
            } else {
                layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(storedWeight.intValue(), storedMinWidth.intValue(), storedIsResizable));
            }
            ++i;
        }
    }

    private static void addColumns(TableViewerSWTCustomization customization, TableViewer tableViewer, EMFDataBindingContext emfDataBindingContext) {
        for (TableViewerSWTCustomization.ColumnDescription columnDescription : customization.getColumns()) {
            TableViewerColumn column = TableViewerColumnBuilder.create().setData(RESIZABLE, (Object)columnDescription.isResizeable()).setMoveable(columnDescription.isMoveable()).setStyle(columnDescription.getStyleBits()).setData(WEIGHT, (Object)columnDescription.getWeight()).setData(MIN_WIDTH, (Object)columnDescription.getMinWidth()).build(tableViewer);
            IObservableValue text = columnDescription.getColumnText();
            emfDataBindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)column.getColumn()), text);
            IObservableValue tooltipText = columnDescription.getColumnTooltip();
            emfDataBindingContext.bindValue((IObservableValue)WidgetProperties.tooltipText().observe((Widget)column.getColumn()), tooltipText);
            column.setLabelProvider(columnDescription.createLabelProvider(tableViewer));
            Optional<EditingSupport> editingSupport = columnDescription.createEditingSupport(tableViewer);
            if (editingSupport.isPresent()) {
                column.setEditingSupport((EditingSupport)editingSupport.get());
            }
            if (columnDescription.getColumnImage().isPresent()) {
                column.getColumn().setImage((Image)columnDescription.getColumnImage().get());
            }
            if (!customization.hasDND()) continue;
            tableViewer.addDragSupport(customization.getDragOperations(), customization.getDragTransferTypes(), customization.getDragListener(tableViewer));
            tableViewer.addDropSupport(customization.getDropOperations(), customization.getDropTransferTypes(), customization.getDropListener(tableViewer));
        }
    }

    private static void enableEditingSupport(TableViewer tableViewer) {
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new ECPFocusCellDrawHighlighter((ColumnViewer)tableViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    private static void enableTooltipSupport(TableViewer tableViewer) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
    }

    private static void initButtonComposite(Composite composite, ButtonBarBuilder customization, TableViewer viewer) {
        customization.fillButtonComposite(composite, viewer);
    }

    private static void initTitleLabel(Label label, IObservableValue title, IObservableValue tooltip, EMFDataBindingContext emfDatabindingContext) {
        emfDatabindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)label), title);
        emfDatabindingContext.bindValue((IObservableValue)WidgetProperties.tooltipText().observe((Widget)label), tooltip);
    }

    public void dispose() {
        this.emfDatabindingContext.dispose();
        super.dispose();
    }
}

