/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.treemasterdetail.decorator.validation.ecp;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.edit.spi.swt.util.SWTValidationHelper;
import org.eclipse.emfforms.internal.swt.treemasterdetail.decorator.validation.ecp.DiagnosticCache;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ECPValidationServiceLabelDecorator
implements ILabelDecorator {
    private final DiagnosticCache cache;
    private final Adapter adapter;
    private final Notifier input;
    private final TreeViewer viewer;

    /*
     * Enabled aggressive block sorting
     */
    public ECPValidationServiceLabelDecorator(TreeViewer viewer, Notifier input) {
        TreeIterator allContents;
        this.viewer = viewer;
        this.input = input;
        this.cache = new DiagnosticCache();
        this.adapter = new ChangeListener();
        input.eAdapters().add((Object)this.adapter);
        if (ResourceSet.class.isInstance(input)) {
            allContents = EcoreUtil.getAllContents((ResourceSet)((ResourceSet)ResourceSet.class.cast(input)), (boolean)false);
        } else if (Resource.class.isInstance(input)) {
            allContents = EcoreUtil.getAllContents((Resource)((Resource)Resource.class.cast(input)), (boolean)false);
        } else {
            if (!EObject.class.isInstance(input)) {
                return;
            }
            allContents = EcoreUtil.getAllContents((EObject)((EObject)EObject.class.cast(input)), (boolean)false);
        }
        while (allContents.hasNext()) {
            Object next = allContents.next();
            if (!EObject.class.isInstance(next)) continue;
            this.updateCacheWithoutRefresh((EObject)EObject.class.cast(next), this.cache);
        }
        viewer.refresh();
    }

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return image;
        }
        if (!EObject.class.isInstance(element) && !Resource.class.isInstance(element)) {
            return image;
        }
        Diagnostic diagnostic = (Diagnostic)this.cache.getCachedValue(element);
        int severity = diagnostic.getSeverity();
        ImageDescriptor validationOverlayDescriptor = SWTValidationHelper.INSTANCE.getValidationOverlayDescriptor(severity);
        if (validationOverlayDescriptor == null) {
            return image;
        }
        Rectangle bounds = image.getBounds();
        Point size = new Point(bounds.width, bounds.height);
        DecorationOverlayIcon icon = new DecorationOverlayIcon(image, new ImageDescriptor[]{validationOverlayDescriptor}, size);
        return icon.createImage();
    }

    private static void handleRemove(EObject oldValue, DiagnosticCache cache) {
        LinkedHashSet<EObject> toRemove = new LinkedHashSet<EObject>();
        toRemove.add(oldValue);
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)oldValue, (boolean)false);
        while (iterator.hasNext()) {
            toRemove.add((EObject)iterator.next());
        }
        for (EObject object : toRemove) {
            cache.remove(object);
        }
    }

    protected void updateCache(EObject element, DiagnosticCache cache) {
        Diagnostic diagnostic = ECPValidationServiceLabelDecorator.getDiagnostic(element);
        Set update = cache.update(element, diagnostic);
        for (EObject eObject : update) {
            this.viewer.refresh((Object)eObject, true);
        }
    }

    protected void updateCacheWithoutRefresh(EObject element, DiagnosticCache cache) {
        Diagnostic diagnostic = ECPValidationServiceLabelDecorator.getDiagnostic(element);
        Set update = cache.update(element, diagnostic);
        this.viewer.update(update.toArray(), null);
        this.viewer.update((Object)element, null);
    }

    private static Diagnostic getDiagnostic(Object object) {
        if (!EObject.class.isInstance(object)) {
            return Diagnostic.OK_INSTANCE;
        }
        EObject eObject = (EObject)EObject.class.cast(object);
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator(eObject.eClass().getEPackage());
        BasicDiagnostic diagnostics = Diagnostician.INSTANCE.createDefaultDiagnostic(eObject);
        if (validator == null) {
            validator = new EObjectValidator();
        }
        HashMap<Class, Object> context = new HashMap<Class, Object>();
        context.put(EValidator.SubstitutionLabelProvider.class, Diagnostician.INSTANCE);
        context.put(EValidator.class, validator);
        validator.validate(eObject, (DiagnosticChain)diagnostics, context);
        return diagnostics;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.input.eAdapters().remove((Object)this.adapter);
    }

    private final class ChangeListener
    extends EContentAdapter {
        private ChangeListener() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.isTouch()) {
                return;
            }
            this.handleStructuralChangeNotification(notification);
            if (!EObject.class.isInstance(notification.getNotifier())) {
                return;
            }
            ECPValidationServiceLabelDecorator.this.updateCacheWithoutRefresh((EObject)EObject.class.cast(notification.getNotifier()), ECPValidationServiceLabelDecorator.this.cache);
        }

        private void handleStructuralChangeNotification(Notification notification) {
            switch (notification.getEventType()) {
                case 4: {
                    this.handleSingleRemove(notification);
                    break;
                }
                case 6: {
                    List deleted = (List)notification.getOldValue();
                    if (deleted.isEmpty() || !EObject.class.isInstance(deleted.get(0))) break;
                    for (Object oldValue : deleted) {
                        ECPValidationServiceLabelDecorator.handleRemove((EObject)EObject.class.cast(oldValue), ECPValidationServiceLabelDecorator.this.cache);
                    }
                    break;
                }
                case 3: {
                    this.handleAdd(notification);
                    break;
                }
                case 5: {
                    List added = (List)notification.getNewValue();
                    if (added.isEmpty() || !EObject.class.isInstance(added.get(0))) break;
                    for (Object newValue : added) {
                        TreeIterator iterator = EcoreUtil.getAllContents((EObject)((EObject)EObject.class.cast(newValue)), (boolean)false);
                        while (iterator.hasNext()) {
                            ECPValidationServiceLabelDecorator.this.updateCacheWithoutRefresh((EObject)iterator.next(), ECPValidationServiceLabelDecorator.this.cache);
                        }
                        ECPValidationServiceLabelDecorator.this.updateCache((EObject)EObject.class.cast(newValue), ECPValidationServiceLabelDecorator.this.cache);
                    }
                    break;
                }
                case 1: {
                    if (!EReference.class.isInstance(notification.getFeature()) || !((EReference)EReference.class.cast(notification.getFeature())).isContainment()) break;
                    this.handleAdd(notification);
                    break;
                }
            }
        }

        private void handleSingleRemove(Notification notification) {
            Object oldValue = notification.getOldValue();
            if (!EObject.class.isInstance(oldValue)) {
                return;
            }
            ECPValidationServiceLabelDecorator.handleRemove((EObject)EObject.class.cast(oldValue), ECPValidationServiceLabelDecorator.this.cache);
        }

        private void handleAdd(Notification notification) {
            Object newValue = notification.getNewValue();
            if (!EObject.class.isInstance(newValue)) {
                return;
            }
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)((EObject)EObject.class.cast(newValue)), (boolean)false);
            while (iterator.hasNext()) {
                ECPValidationServiceLabelDecorator.this.updateCacheWithoutRefresh((EObject)iterator.next(), ECPValidationServiceLabelDecorator.this.cache);
            }
            ECPValidationServiceLabelDecorator.this.updateCache((EObject)EObject.class.cast(newValue), ECPValidationServiceLabelDecorator.this.cache);
        }
    }
}

