/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Map;
import org.testng.IDataProviderListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Parameters;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.util.Strings;
import org.testng.xml.XmlSuite;

class ParameterHandler {
    private final IAnnotationFinder finder;
    private final Collection<IDataProviderListener> listeners;

    ParameterHandler(IAnnotationFinder iAnnotationFinder, Collection<IDataProviderListener> collection) {
        this.finder = iAnnotationFinder;
        this.listeners = collection;
    }

    ParameterBag createParameters(ITestNGMethod iTestNGMethod, Map<String, String> map, Map<String, String> map2, ITestContext iTestContext) {
        return this.createParameters(iTestNGMethod, map, map2, iTestContext, null);
    }

    ParameterBag createParameters(ITestNGMethod iTestNGMethod, Map<String, String> map, Map<String, String> map2, ITestContext iTestContext, Object object) {
        return this.handleParameters(iTestNGMethod, iTestNGMethod.getInstance(), map2, map, iTestContext, object);
    }

    private ParameterBag handleParameters(ITestNGMethod iTestNGMethod, Object object, Map<String, String> map, Map<String, String> map2, ITestContext iTestContext, Object object2) {
        XmlSuite xmlSuite = iTestContext.getCurrentXmlTest().getSuite();
        try {
            Parameters.MethodParameters methodParameters = Parameters.MethodParameters.newInstance(map2, iTestNGMethod, iTestContext);
            ParameterHolder parameterHolder = Parameters.handleParameters(iTestNGMethod, map, object, methodParameters, xmlSuite, this.finder, object2, this.listeners);
            return new ParameterBag(parameterHolder);
        }
        catch (Throwable throwable) {
            String string = Utils.longStackTrace(throwable.getCause() != null ? throwable.getCause() : throwable, true);
            if (Strings.isNotNullAndNotEmpty(string)) {
                Utils.error(string);
            }
            TestResult testResult = new TestResult(object, iTestNGMethod, throwable, iTestContext);
            return new ParameterBag(testResult);
        }
    }

    static class ParameterBag {
        final ParameterHolder parameterHolder;
        final ITestResult errorResult;

        ParameterBag(ParameterHolder parameterHolder) {
            this.parameterHolder = parameterHolder;
            this.errorResult = null;
        }

        ParameterBag(ITestResult iTestResult) {
            this.parameterHolder = null;
            this.errorResult = iTestResult;
        }

        boolean hasErrors() {
            return this.errorResult != null;
        }

        boolean runInParallel() {
            return this.parameterHolder != null && this.parameterHolder.origin == ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER && this.parameterHolder.dataProviderHolder.isParallel();
        }
    }
}

