/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.TestListenerAdapter;
import org.testng.TestRunner;
import org.testng.internal.Utils;
import org.testng.reporters.HtmlHelper;

public class TestHTMLReporter
extends TestListenerAdapter {
    private static final Comparator<ITestResult> NAME_COMPARATOR = new NameComparator();
    private static final Comparator<ITestResult> CONFIGURATION_COMPARATOR = new ConfigurationComparator();
    private ITestContext m_testContext = null;
    private static final String HEAD = "\n<style type=\"text/css\">\n.log { display: none;} \n.stack-trace { display: none;} \n</style>\n<script type=\"text/javascript\">\n<!--\nfunction flip(e) {\n  current = e.style.display;\n  if (current == 'block') {\n    e.style.display = 'none';\n    return 0;\n  }\n  else {\n    e.style.display = 'block';\n    return 1;\n  }\n}\n\nfunction toggleBox(szDivId, elem, msg1, msg2)\n{\n  var res = -1;  if (document.getElementById) {\n    res = flip(document.getElementById(szDivId));\n  }\n  else if (document.all) {\n    // this is the way old msie versions work\n    res = flip(document.all[szDivId]);\n  }\n  if(elem) {\n    if(res == 0) elem.innerHTML = msg1; else elem.innerHTML = msg2;\n  }\n\n}\n\nfunction toggleAllBoxes() {\n  if (document.getElementsByTagName) {\n    d = document.getElementsByTagName('div');\n    for (i = 0; i < d.length; i++) {\n      if (d[i].className == 'log') {\n        flip(d[i]);\n      }\n    }\n  }\n}\n\n// -->\n</script>\n\n";

    @Override
    public void onStart(ITestContext iTestContext) {
        this.m_testContext = iTestContext;
    }

    @Override
    public void onFinish(ITestContext iTestContext) {
        TestHTMLReporter.generateLog(this.m_testContext, null, this.m_testContext.getOutputDirectory(), this.getConfigurationFailures(), this.getConfigurationSkips(), this.getPassedTests(), this.getFailedTests(), this.getSkippedTests(), this.getFailedButWithinSuccessPercentageTests());
    }

    private static String getOutputFile(ITestContext iTestContext) {
        return iTestContext.getName() + ".html";
    }

    public static void generateTable(PrintWriter printWriter, String string, Collection<ITestResult> collection, String string2, Comparator<ITestResult> comparator) {
        printWriter.append("<table width='100%' border='1' class='invocation-").append(string2).append("'>\n").append("<tr><td colspan='4' align='center'><b>").append(string).append("</b></td></tr>\n").append("<tr>").append("<td><b>Test method</b></td>\n").append("<td width=\"30%\"><b>Exception</b></td>\n").append("<td width=\"10%\"><b>Time (seconds)</b></td>\n").append("<td><b>Instance</b></td>\n").append("</tr>\n");
        if (collection instanceof List) {
            Collections.sort((List)collection, comparator);
        }
        for (ITestResult iTestResult : collection) {
            String string3;
            Object object;
            Object object2;
            printWriter.append("<tr>\n");
            ITestNGMethod iTestNGMethod = iTestResult.getMethod();
            String string4 = iTestNGMethod.getMethodName();
            printWriter.append("<td title='").append(iTestResult.getTestClass().getName()).append(".").append(string4).append("()'>").append("<b>").append(string4).append("</b>");
            String string5 = iTestResult.getTestClass().getName();
            if (string5 != null) {
                printWriter.append("<br>").append("Test class: ").append(string5);
                object2 = iTestResult.getTestName();
                if (object2 != null) {
                    printWriter.append(" (").append((CharSequence)object2).append(")");
                }
            }
            if (!Utils.isStringEmpty(iTestNGMethod.getDescription())) {
                printWriter.append("<br>").append("Test method: ").append(iTestNGMethod.getDescription());
            }
            if ((object2 = iTestResult.getParameters()) != null && ((Object[])object2).length > 0) {
                printWriter.append("<br>Parameters: ");
                for (int i = 0; i < ((Object[])object2).length; ++i) {
                    if (i > 0) {
                        printWriter.append(", ");
                    }
                    printWriter.append(object2[i] == null ? "null" : object2[i].toString());
                }
            }
            if (null != (object = Reporter.getOutput(iTestResult)) && object.size() > 0) {
                printWriter.append("<br/>");
                string3 = "Output-" + iTestResult.hashCode();
                printWriter.append("\n<a href=\"#").append(string3).append("\"").append(" onClick='toggleBox(\"").append(string3).append("\", this, \"Show output\", \"Hide output\");'>").append("Show output</a>\n").append("\n<a href=\"#").append(string3).append("\"").append(" onClick=\"toggleAllBoxes();\">Show all outputs</a>\n");
                printWriter.append("<div class='log' id=\"").append(string3).append("\">\n");
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    printWriter.append(string6).append("<br/>\n");
                }
                printWriter.append("</div>\n");
            }
            printWriter.append("</td>\n");
            Throwable throwable = iTestResult.getThrowable();
            String string7 = "stack-trace" + iTestResult.hashCode();
            printWriter.append("<td>");
            if (null != throwable) {
                string3 = Utils.longStackTrace(throwable, true);
                object = "<div><pre>" + Utils.shortStackTrace(throwable, true) + "</pre></div>";
                printWriter.append((CharSequence)object);
                printWriter.append("<a href='#' onClick='toggleBox(\"").append(string7).append("\", this, \"Click to show all stack frames\", \"Click to hide stack frames\")'>").append("Click to show all stack frames").append("</a>\n").append("<div class='stack-trace' id='").append(string7).append("'>").append("<pre>").append(string3).append("</pre>").append("</div>");
            }
            printWriter.append("</td>\n");
            long l = (iTestResult.getEndMillis() - iTestResult.getStartMillis()) / 1000L;
            String string8 = Long.toString(l);
            printWriter.append("<td>").append(string8).append("</td>\n");
            Object object3 = iTestResult.getInstance();
            printWriter.append("<td>").append(Objects.toString(object3)).append("</td>");
            printWriter.append("</tr>\n");
        }
        printWriter.append("</table><p>\n");
    }

    private static String arrayToString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(" ");
        }
        return stringBuilder.toString();
    }

    public static void generateLog(ITestContext iTestContext, String string, String string2, Collection<ITestResult> collection, Collection<ITestResult> collection2, Collection<ITestResult> collection3, Collection<ITestResult> collection4, Collection<ITestResult> collection5, Collection<ITestResult> collection6) {
        try (PrintWriter printWriter = new PrintWriter(Utils.openWriter(string2, TestHTMLReporter.getOutputFile(iTestContext)));){
            printWriter.append("<html>\n<head>\n").append("<title>TestNG:  ").append(iTestContext.getName()).append("</title>\n").append(HtmlHelper.getCssString()).append(HEAD).append("</head>\n").append("<body>\n");
            Date date = iTestContext.getStartDate();
            Date date2 = iTestContext.getEndDate();
            long l = (date2.getTime() - date.getTime()) / 1000L;
            int n = iTestContext.getPassedTests().size() + iTestContext.getFailedButWithinSuccessPercentageTests().size();
            int n2 = iTestContext.getFailedTests().size();
            int n3 = iTestContext.getSkippedTests().size();
            String string3 = Utils.isStringEmpty(string) ? "" : "<tr><td>Remote host:</td><td>" + string + "</td>\n</tr>";
            printWriter.append("<h2 align='center'>").append(iTestContext.getName()).append("</h2>").append("<table border='1' align=\"center\">\n").append("<tr>\n").append("<td>Tests passed/Failed/Skipped:</td><td>").append(Integer.toString(n)).append("/").append(Integer.toString(n2)).append("/").append(Integer.toString(n3)).append("</td>\n").append("</tr><tr>\n").append("<td>Started on:</td><td>").append(iTestContext.getStartDate().toString()).append("</td>\n").append("</tr>\n").append(string3).append("<tr><td>Total time:</td><td>").append(Long.toString(l)).append(" seconds (").append(Long.toString(date2.getTime() - date.getTime())).append(" ms)</td>\n").append("</tr><tr>\n").append("<td>Included groups:</td><td>").append(TestHTMLReporter.arrayToString(iTestContext.getIncludedGroups())).append("</td>\n").append("</tr><tr>\n").append("<td>Excluded groups:</td><td>").append(TestHTMLReporter.arrayToString(iTestContext.getExcludedGroups())).append("</td>\n").append("</tr>\n").append("</table><p/>\n");
            printWriter.append("<small><i>(Hover the method name to see the test class name)</i></small><p/>\n");
            if (!collection.isEmpty()) {
                TestHTMLReporter.generateTable(printWriter, "FAILED CONFIGURATIONS", collection, "failed", CONFIGURATION_COMPARATOR);
            }
            if (!collection2.isEmpty()) {
                TestHTMLReporter.generateTable(printWriter, "SKIPPED CONFIGURATIONS", collection2, "skipped", CONFIGURATION_COMPARATOR);
            }
            if (!collection4.isEmpty()) {
                TestHTMLReporter.generateTable(printWriter, "FAILED TESTS", collection4, "failed", NAME_COMPARATOR);
            }
            if (!collection6.isEmpty()) {
                TestHTMLReporter.generateTable(printWriter, "FAILED TESTS BUT WITHIN SUCCESS PERCENTAGE", collection6, "percent", NAME_COMPARATOR);
            }
            if (!collection3.isEmpty()) {
                TestHTMLReporter.generateTable(printWriter, "PASSED TESTS", collection3, "passed", NAME_COMPARATOR);
            }
            if (!collection5.isEmpty()) {
                TestHTMLReporter.generateTable(printWriter, "SKIPPED TESTS", collection5, "skipped", NAME_COMPARATOR);
            }
            printWriter.append("</body>\n</html>");
        }
        catch (IOException iOException) {
            if (TestRunner.getVerbose() > 1) {
                iOException.printStackTrace();
            }
            TestHTMLReporter.ppp(iOException.getMessage());
        }
    }

    private static void ppp(String string) {
        System.out.println("[TestHTMLReporter] " + string);
    }

    private static class ConfigurationComparator
    implements Comparator<ITestResult> {
        private ConfigurationComparator() {
        }

        @Override
        public int compare(ITestResult iTestResult, ITestResult iTestResult2) {
            ITestNGMethod iTestNGMethod = iTestResult.getMethod();
            ITestNGMethod iTestNGMethod2 = iTestResult2.getMethod();
            return ConfigurationComparator.annotationValue(iTestNGMethod2) - ConfigurationComparator.annotationValue(iTestNGMethod);
        }

        private static int annotationValue(ITestNGMethod iTestNGMethod) {
            if (iTestNGMethod.isBeforeSuiteConfiguration()) {
                return 10;
            }
            if (iTestNGMethod.isBeforeTestConfiguration()) {
                return 9;
            }
            if (iTestNGMethod.isBeforeClassConfiguration()) {
                return 8;
            }
            if (iTestNGMethod.isBeforeGroupsConfiguration()) {
                return 7;
            }
            if (iTestNGMethod.isBeforeMethodConfiguration()) {
                return 6;
            }
            if (iTestNGMethod.isAfterMethodConfiguration()) {
                return 5;
            }
            if (iTestNGMethod.isAfterGroupsConfiguration()) {
                return 4;
            }
            if (iTestNGMethod.isAfterClassConfiguration()) {
                return 3;
            }
            if (iTestNGMethod.isAfterTestConfiguration()) {
                return 2;
            }
            if (iTestNGMethod.isAfterSuiteConfiguration()) {
                return 1;
            }
            return 0;
        }
    }

    private static class NameComparator
    implements Comparator<ITestResult> {
        private NameComparator() {
        }

        @Override
        public int compare(ITestResult iTestResult, ITestResult iTestResult2) {
            String string = iTestResult.getMethod().getMethodName();
            String string2 = iTestResult2.getMethod().getMethodName();
            return string.compareTo(string2);
        }
    }
}

