/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import jakarta.validation.Validator;
import jakarta.validation.constraints.Pattern;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class PatternConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)PatternConstraintTest.webArchiveBuilder().withTestClass(PatternConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-pattern", id="a")})
    public void testPatternConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PatternDummyEntity dummy = new PatternDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.pattern = "ab cd";
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class).withProperty("pattern").withInvalidValue("ab cd").withRootBeanClass(PatternDummyEntity.class));
        dummy.pattern = "wc 00";
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    private static class PatternDummyEntity {
        @Pattern(regexp="[a-z][a-z] \\d\\d")
        private @Pattern(regexp="[a-z][a-z] \\d\\d") String pattern;

        private PatternDummyEntity() {
        }
    }
}

