/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.orm20;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.orm20.Table;
import org.jboss.shrinkwrap.descriptor.api.orm20.UniqueConstraint;
import org.jboss.shrinkwrap.descriptor.impl.orm20.UniqueConstraintImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableImpl<T>
implements Child<T>,
Table<T> {
    private T t;
    private Node childNode;

    public TableImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public TableImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public UniqueConstraint<Table<T>> getOrCreateUniqueConstraint() {
        List nodeList = this.childNode.get("unique-constraint");
        if (nodeList != null && nodeList.size() > 0) {
            return new UniqueConstraintImpl<Table<T>>(this, "unique-constraint", this.childNode, (Node)nodeList.get(0));
        }
        return this.createUniqueConstraint();
    }

    public UniqueConstraint<Table<T>> createUniqueConstraint() {
        return new UniqueConstraintImpl<Table<T>>(this, "unique-constraint", this.childNode);
    }

    public List<UniqueConstraint<Table<T>>> getAllUniqueConstraint() {
        ArrayList<UniqueConstraint<Table<T>>> list = new ArrayList<UniqueConstraint<Table<T>>>();
        List nodeList = this.childNode.get("unique-constraint");
        for (Node node : nodeList) {
            UniqueConstraintImpl<TableImpl> type = new UniqueConstraintImpl<TableImpl>(this, "unique-constraint", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public Table<T> removeAllUniqueConstraint() {
        this.childNode.removeChildren("unique-constraint");
        return this;
    }

    public Table<T> name(String name) {
        this.childNode.attribute("name", name);
        return this;
    }

    public String getName() {
        return this.childNode.getAttribute("name");
    }

    public Table<T> removeName() {
        this.childNode.removeAttribute("name");
        return this;
    }

    public Table<T> catalog(String catalog) {
        this.childNode.attribute("catalog", catalog);
        return this;
    }

    public String getCatalog() {
        return this.childNode.getAttribute("catalog");
    }

    public Table<T> removeCatalog() {
        this.childNode.removeAttribute("catalog");
        return this;
    }

    public Table<T> schema(String schema) {
        this.childNode.attribute("schema", schema);
        return this;
    }

    public String getSchema() {
        return this.childNode.getAttribute("schema");
    }

    public Table<T> removeSchema() {
        this.childNode.removeAttribute("schema");
        return this;
    }
}

