/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.trimmed;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.deployment.trimmed.Bike;
import org.jboss.cdi.tck.tests.deployment.trimmed.Bus;
import org.jboss.cdi.tck.tests.deployment.trimmed.MotorizedVehicle;
import org.jboss.cdi.tck.tests.deployment.trimmed.Segway;
import org.jboss.cdi.tck.tests.deployment.trimmed.TestExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class TrimmedBeanArchiveTest
extends AbstractTest {
    @Inject
    TestExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(TrimmedBeanArchiveTest.class)).withExtension(TestExtension.class)).withBeansXml("beans.xml")).build();
    }

    @Test
    @SpecAssertion(section="trimmed_bean_archive", id="a")
    public void testDiscoveredBean() {
        Assert.assertEquals((int)this.extension.getVehiclePBAinvocations().get(), (int)1);
        Bean<MotorizedVehicle> vehicleBean = this.getUniqueBean(MotorizedVehicle.class, new Annotation[0]);
        CreationalContext cc = this.getCurrentManager().createCreationalContext(vehicleBean);
        MotorizedVehicle vehicle = (MotorizedVehicle)this.getCurrentManager().getReference(vehicleBean, MotorizedVehicle.class, cc);
        Assert.assertEquals((String)Bus.class.getSimpleName(), (String)vehicle.start());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="trimmed_bean_archive", id="a")
    public void testProducerNotDsicovered(Instance<Bike> bikeInstance) {
        Assert.assertTrue((boolean)this.extension.isBikerProducerPATFired());
        Assert.assertFalse((boolean)this.extension.isBikerProducerPBAFired());
        Assert.assertFalse((boolean)bikeInstance.isAmbiguous());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="trimmed_bean_archive", id="a")
    public void testDiscoveredBeanWithStereoType(Instance<Segway> segwayInstance) {
        Assert.assertFalse((boolean)segwayInstance.isUnsatisfied());
    }
}

