/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.inheritance.specialization.simple;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.Farmer;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.Human;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.Landowner;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.Lazy;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.LazyFarmer;
import org.jboss.cdi.tck.tests.inheritance.specialization.simple.Waste;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class SimpleBeanSpecializationTest
extends AbstractTest {
    private static Annotation LANDOWNER_LITERAL = new AnnotationLiteral<Landowner>(){};
    private static Annotation LAZY_LITERAL = new AnnotationLiteral<Lazy>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SimpleBeanSpecializationTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="direct_and_indirect_specialization", id="ia"), @SpecAssertion(section="direct_and_indirect_specialization", id="ib")})
    public void testIndirectSpecialization() {
        Set<Bean<Human>> humanBeans = this.getBeans(Human.class, new Annotation[0]);
        Assert.assertEquals((int)humanBeans.size(), (int)1);
        Set<Bean<Farmer>> farmerBeans = this.getBeans(Farmer.class, LANDOWNER_LITERAL);
        Assert.assertEquals((int)farmerBeans.size(), (int)1);
        Bean<Farmer> lazyFarmerBean = farmerBeans.iterator().next();
        Assert.assertEquals((Object)lazyFarmerBean.getBeanClass(), (Object)humanBeans.iterator().next().getBeanClass());
        Set lazyFarmerBeanTypes = lazyFarmerBean.getTypes();
        Assert.assertEquals((int)lazyFarmerBeanTypes.size(), (int)4);
        Assert.assertTrue((boolean)this.typeSetMatches(lazyFarmerBeanTypes, new Type[]{Object.class, Human.class, Farmer.class, LazyFarmer.class}));
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="direct_and_indirect_specialization", id="ia")})
    public void testSpecializingBeanInjection(Farmer farmer) {
        Assert.assertEquals((String)farmer.getClassName(), (String)LazyFarmer.class.getName());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="direct_and_indirect_specialization", id="j"), @SpecAssertion(section="specialize_managed_bean", id="aa")})
    public void testSpecializingBeanHasQualifiersOfSpecializedAndSpecializingBean() {
        Bean<LazyFarmer> lazyFarmerBean = this.getBeans(LazyFarmer.class, LAZY_LITERAL).iterator().next();
        Set lazyFarmerBeanQualifiers = lazyFarmerBean.getQualifiers();
        Assert.assertEquals((int)lazyFarmerBeanQualifiers.size(), (int)5);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)lazyFarmerBean.getQualifiers(), Landowner.class, Lazy.class, Any.class, Named.class, Default.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="direct_and_indirect_specialization", id="k"), @SpecAssertion(section="specialize_managed_bean", id="ab")})
    public void testSpecializingBeanHasNameOfSpecializedBean() {
        String expectedName = "farmer";
        Set beans = this.getCurrentManager().getBeans(expectedName);
        Assert.assertEquals((int)beans.size(), (int)1);
        Bean farmerBean = (Bean)beans.iterator().next();
        Assert.assertEquals((String)farmerBean.getName(), (String)expectedName);
        Assert.assertEquals((Object)farmerBean.getBeanClass(), LazyFarmer.class);
    }

    @Test(expectedExceptions={UnsatisfiedResolutionException.class})
    @SpecAssertions(value={@SpecAssertion(section="specialization", id="cb")})
    public void testProducerMethodOnSpecializedBeanNotCalled() {
        Assert.assertEquals((int)this.getBeans(Waste.class, new Annotation[0]).size(), (int)0);
        this.getContextualReference(Waste.class, new Annotation[0]);
    }
}

