/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.cdi.tck.tests.extensions.lifecycle.bbd;

import static org.jboss.cdi.tck.cdi.Sections.AFTER_BEAN_DISCOVERY;
import static org.jboss.cdi.tck.cdi.Sections.AFTER_DEPLOYMENT_VALIDATION;
import static org.jboss.cdi.tck.cdi.Sections.BEAN;
import static org.testng.Assert.assertFalse;
import static org.testng.Assert.assertTrue;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

/**
 * Tests related to the final deployment phase of the lifecycle.
 * 
 * @author David Allen
 * @author Martin Kouba
 */
@SpecVersion(spec = "cdi", version = "2.0")
@Test
public class DeploymentTest extends AbstractTest {

    @Deployment
    public static WebArchive createTestArchive() {
        return new WebArchiveBuilder().withTestClassPackage(DeploymentTest.class).withExtension(ManagerObserver.class).build();
    }

    @Test
    @SpecAssertions({ @SpecAssertion(section = AFTER_BEAN_DISCOVERY, id = "a"), @SpecAssertion(section = AFTER_DEPLOYMENT_VALIDATION, id = "a") })
    public void testDeployedManagerEvent() {
        assertTrue(ManagerObserver.isAfterDeploymentValidationCalled());
        assertTrue(ManagerObserver.isAfterBeanDiscoveryCalled());
    }

    @Test
    @SpecAssertions({ @SpecAssertion(section = BEAN, id = "f") })
    public void testOnlyEnabledBeansDeployed() {
        assertFalse(getBeans(User.class).isEmpty());
        assertTrue(getBeans(DataAccessAuthorizationDecorator.class).isEmpty());
        assertTrue(getBeans(Interceptor1.class).isEmpty());
        assertTrue(getBeans(DisabledBean.class).isEmpty());
    }
}
