/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.configurators.producer;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessProducer;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.cdi.tck.tests.extensions.configurators.producer.Bar;
import org.jboss.cdi.tck.tests.extensions.configurators.producer.MassProducer;
import org.jboss.cdi.tck.tests.extensions.configurators.producer.ParameterInjectedBean;
import org.jboss.cdi.tck.tests.extensions.configurators.producer.Some;

public class ProducerConfiguringExtension
implements Extension {
    public static AtomicBoolean producerCalled = new AtomicBoolean(false);
    public static AtomicBoolean disposerCalled = new AtomicBoolean(false);

    public void observeProducer(@Observes ProcessProducer<MassProducer, Bar> event) {
        if (this.isProducerWithAnnotation(event, Some.SomeLiteral.INSTANCE)) {
            event.configureProducer().disposeWith((Consumer)new Consumer<Bar>(){

                @Override
                public void accept(Bar t) {
                    disposerCalled.set(true);
                }
            }).produceWith((Function)new Function<CreationalContext<Bar>, Bar>(){

                @Override
                public Bar apply(CreationalContext<Bar> t) {
                    producerCalled.set(true);
                    return new Bar(new ParameterInjectedBean(null));
                }
            });
        }
    }

    private boolean isProducerWithAnnotation(ProcessProducer<MassProducer, Bar> event, Annotation annotation) {
        return event.getAnnotatedMember().getAnnotations().contains(annotation);
    }
}

