/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.jboss.cdi.tck.tests.context.application.Result;

public class TestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Inject
    private BeanManager jsr299Manager;
    @Inject
    private Result result;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if ("servlet".equals(req.getParameter("test"))) {
            if (this.jsr299Manager.getContext(ApplicationScoped.class).isActive()) {
                resp.setStatus(200);
            } else {
                resp.setStatus(500);
            }
        } else if ("servletContextListener".equals(req.getParameter("test"))) {
            this.testServletContextListener(req, resp);
        } else if ("httpSessionListener".equals(req.getParameter("test"))) {
            this.testHttpSessionListener(req, resp);
        } else if ("servletRequestListener".equals(req.getParameter("test"))) {
            this.testServletRequestListener(req, resp);
        } else {
            resp.setStatus(404);
        }
    }

    private void testServletContextListener(HttpServletRequest req, HttpServletResponse resp) {
        resp.setStatus(this.result.isApplicationScopeActiveForServletContextListener() ? 200 : 500);
    }

    private void testHttpSessionListener(HttpServletRequest req, HttpServletResponse resp) {
        req.getSession().setAttribute("foo", (Object)"bar");
        resp.setStatus(this.result.isApplicationScopeActiveForHttpSessionListener() ? 200 : 500);
    }

    private void testServletRequestListener(HttpServletRequest req, HttpServletResponse resp) {
        resp.setStatus(this.result.isApplicationScopeActiveForServletRequestListener() ? 200 : 500);
    }
}

