/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.ee.components;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.UUID;
import org.jboss.cdi.tck.tests.implementation.simple.ee.components.Ping;
import org.jboss.cdi.tck.tests.implementation.simple.ee.components.Tame;
import org.jboss.cdi.tck.tests.implementation.simple.ee.components.Wild;
import org.jboss.cdi.tck.util.ActionSequence;

@WebServlet(value={"/test"})
public class IntrospectServlet
extends HttpServlet {
    public static final String MODE_INJECT = "inject";
    public static final String MODE_PRODUCER_METHOD = "pm";
    public static final String MODE_PRODUCER_FIELD = "pf";
    public static final String MODE_DISPOSER_METHOD = "dm";
    public static final String MODE_OBSERVER_METHOD = "om";
    private String id = null;
    @Inject
    @Any
    Instance<Ping> pingInstance;
    @Inject
    @Any
    Event<Ping> pingEvent;
    @Produces
    @Wild
    @Dependent
    Ping ping;

    @PostConstruct
    public void init() {
        this.id = UUID.randomUUID().toString();
        this.ping = new Ping(this.id);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/text");
        String mode = req.getParameter("mode");
        if (MODE_INJECT.equals(mode)) {
            resp.getWriter().println(((Ping)this.pingInstance.select(new Annotation[]{Default.Literal.INSTANCE}).get()).pong() + ":" + this.getId());
        } else if (MODE_PRODUCER_METHOD.equals(mode)) {
            resp.getWriter().println(((Ping)this.pingInstance.select(new Annotation[]{Tame.TameLiteral.INSTANCE}).get()).getTestServletId() + ":" + this.getId());
        } else if (MODE_PRODUCER_FIELD.equals(mode)) {
            resp.getWriter().println(((Ping)this.pingInstance.select(new Annotation[]{Wild.WildLiteral.INSTANCE}).get()).getTestServletId() + ":" + this.getId());
        } else if (MODE_OBSERVER_METHOD.equals(mode)) {
            this.pingEvent.select(new Annotation[]{Default.Literal.INSTANCE}).fire((Object)new Ping());
            resp.getWriter().println((String)ActionSequence.getSequenceData().get(0) + ":" + this.getId());
        } else if (MODE_DISPOSER_METHOD.equals(mode)) {
            this.pingEvent.select(new Annotation[]{Wild.WildLiteral.INSTANCE}).fire((Object)new Ping());
            resp.getWriter().println((String)ActionSequence.getSequenceData().get(0) + ":" + this.getId());
        } else {
            throw new ServletException("Unknown mode");
        }
    }

    @Tame
    @Produces
    @Dependent
    public Ping procudeTamePing() {
        return new Ping(this.getId());
    }

    public void disposeTamePing(@Disposes @Tame Ping ping) {
        this.storeCdiBeanId();
    }

    public void observePing(@Observes Ping ping) {
        this.storeCdiBeanId();
    }

    public void observeWildPing(@Observes @Wild Ping ping, @Tame Ping tamePing) {
    }

    public String getId() {
        return this.id;
    }

    private void storeCdiBeanId() {
        ActionSequence.reset();
        ActionSequence.addAction((String)this.id);
    }
}

