/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.context.alterable;

import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.context.alterable.AbstractComponent;
import org.jboss.cdi.tck.tests.full.context.alterable.CustomScopeExtension;
import org.jboss.cdi.tck.tests.full.context.alterable.CustomScopedComponent;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class AlterableContextTest
extends AbstractTest {
    private static final String[] VALUES = new String[]{"foo", "bar", "baz"};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AlterableContextTest.class)).withExtension(CustomScopeExtension.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).build();
    }

    @Test(groups={"cdi-full"})
    @SpecAssertion(section="context", id="t")
    public void testCustomScopedComponent() {
        this.testComponent(CustomScopedComponent.class);
    }

    private <T extends AbstractComponent> void testComponent(Class<T> javaClass) {
        Bean<T> bean = this.getUniqueBean(javaClass, new Annotation[0]);
        AbstractComponent reference = (AbstractComponent)this.getCurrentManager().getReference(bean, javaClass, this.getCurrentManager().createCreationalContext(bean));
        AlterableContext context = (AlterableContext)this.getCurrentManager().getContext(bean.getScope());
        for (String string : VALUES) {
            Assert.assertNull((Object)reference.getValue());
            reference.setValue(string);
            Assert.assertEquals((String)reference.getValue(), (String)string);
            AbstractComponent.reset();
            context.destroy(bean);
            Assert.assertTrue((boolean)AbstractComponent.isDestroyed());
            Assert.assertNull((Object)reference.getValue(), (String)reference.getValue());
        }
    }
}

