/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.lookup.injectionpoint;

import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import java.util.Date;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.Logger;

@Decorator
public class TimestampLogger
implements Logger {
    @Inject
    @Delegate
    private Logger logger;
    private static Logger staticLogger;
    private static String loggedMessage;

    @Override
    public void log(String message) {
        staticLogger = this.logger;
        loggedMessage = message;
        this.logger.log(new Date().toString() + ":  " + message);
    }

    public static Logger getLogger() {
        return staticLogger;
    }

    public static String getLoggedMessage() {
        return loggedMessage;
    }

    public static void reset() {
        loggedMessage = null;
        staticLogger = null;
    }
}

