/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.lookup.injectionpoint;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.BeanWithInjectionPointMetadata;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.FieldInjectionPointBean;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.Logger;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.LoggerConsumer;
import org.jboss.cdi.tck.tests.full.lookup.injectionpoint.TimestampLogger;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class InjectableReferenceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InjectableReferenceTest.class)).withBeansXml(new BeansXml().decorators(TimestampLogger.class))).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_injectable_reference", id="a"), @SpecAssertion(section="bm_obtain_injectable_reference", id="ab"), @SpecAssertion(section="bm_obtain_creationalcontext", id="a"), @SpecAssertion(section="injectable_reference", id="a")})
    public void testGetInjectableReferenceOnBeanManager() {
        BeanWithInjectionPointMetadata.reset();
        FieldInjectionPointBean beanWithInjectedBean = this.getContextualReference(FieldInjectionPointBean.class, new Annotation[0]);
        BeanWithInjectionPointMetadata beanWithInjectionPoint = beanWithInjectedBean.getInjectedBean();
        InjectionPoint ip = beanWithInjectionPoint.getInjectedMetadata();
        assert (ip != null);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext((Contextual)ip.getBean());
        Object beanInstance = this.getCurrentManager().getInjectableReference(ip, creationalContext);
        assert (beanInstance instanceof BeanWithInjectionPointMetadata);
        Bean<BeanWithInjectionPointMetadata> bean = this.getUniqueBean(BeanWithInjectionPointMetadata.class, new Annotation[0]);
        bean.destroy((Object)((BeanWithInjectionPointMetadata)beanInstance), creationalContext);
        assert (BeanWithInjectionPointMetadata.isDestroyed());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_injectable_reference", id="b")})
    public void testGetInjectableReferenceReturnsDelegateForDelegateInjectionPoint() {
        assert (this.getBeans(LoggerConsumer.class, new Annotation[0]).size() == 1);
        Bean<LoggerConsumer> bean = this.getBeans(LoggerConsumer.class, new Annotation[0]).iterator().next();
        InjectionPoint loggerInjectionPoint = null;
        for (InjectionPoint ip : bean.getInjectionPoints()) {
            if (!ip.getAnnotated().getTypeClosure().contains(Logger.class) || ip.getQualifiers().size() != 1 || !ip.getQualifiers().contains(Default.Literal.INSTANCE)) continue;
            loggerInjectionPoint = ip;
        }
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext((Contextual)loggerInjectionPoint.getBean());
        Object injectedDelegateLogger = this.getCurrentManager().getInjectableReference(loggerInjectionPoint, creationalContext);
        assert (injectedDelegateLogger instanceof Logger);
        Logger logger = (Logger)injectedDelegateLogger;
        String message = "foo123";
        TimestampLogger.reset();
        logger.log(message);
        assert (message.equals(TimestampLogger.getLoggedMessage()));
    }
}

