/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.PackageInfo;
import org.jboss.cdi.lang.model.tck.AnnPackage;
import org.jboss.cdi.lang.model.tck.AnnotatedReceiverTypes;
import org.jboss.cdi.lang.model.tck.AnnotatedSuperTypes;
import org.jboss.cdi.lang.model.tck.AnnotatedThrowsTypes;
import org.jboss.cdi.lang.model.tck.AnnotatedTypes;
import org.jboss.cdi.lang.model.tck.AnnotationInstances;
import org.jboss.cdi.lang.model.tck.AnnotationMembers;
import org.jboss.cdi.lang.model.tck.BridgeMethods;
import org.jboss.cdi.lang.model.tck.ClassAnnotation;
import org.jboss.cdi.lang.model.tck.DefaultConstructors;
import org.jboss.cdi.lang.model.tck.EnumMembers;
import org.jboss.cdi.lang.model.tck.Equality;
import org.jboss.cdi.lang.model.tck.InheritedAnnotations;
import org.jboss.cdi.lang.model.tck.InheritedFields;
import org.jboss.cdi.lang.model.tck.InheritedMethods;
import org.jboss.cdi.lang.model.tck.InterfaceMembers;
import org.jboss.cdi.lang.model.tck.JavaLangObjectMethods;
import org.jboss.cdi.lang.model.tck.LangModelUtils;
import org.jboss.cdi.lang.model.tck.MissingAnnotation;
import org.jboss.cdi.lang.model.tck.PlainClassMembers;
import org.jboss.cdi.lang.model.tck.PrimitiveTypes;
import org.jboss.cdi.lang.model.tck.RecordMembers;
import org.jboss.cdi.lang.model.tck.RepeatableAnnotations;
import org.jboss.cdi.lang.model.tck.RuntimeAnnotation;
import org.jboss.cdi.lang.model.tck.SealedClasses;
import org.jboss.cdi.lang.model.tck.SealedInterfaces;
import org.jboss.cdi.lang.model.tck.SourceAnnotation;

@RuntimeAnnotation
@ClassAnnotation
public class LangModelVerifier {
    public static boolean RUN_TYPE_ANNOTATION_TESTS = true;
    AnnotatedTypes annotatedTypes;
    AnnotatedSuperTypes annotatedSuperTypes;
    AnnotatedThrowsTypes annotatedThrowsTypes;
    AnnotatedReceiverTypes annotatedReceiverTypes;
    AnnotationInstances annotationInstances;
    PlainClassMembers plainClassMembers;
    InterfaceMembers interfaceMembers;
    AnnotationMembers annotationMembers;
    EnumMembers enumMembers;
    RecordMembers recordMembers;
    InheritedMethods inheritedMethods;
    InheritedFields inheritedFields;
    InheritedAnnotations inheritedAnnotations;
    JavaLangObjectMethods javaLangObjectMethods;
    PrimitiveTypes primitiveTypes;
    BridgeMethods bridgeMethods;
    RepeatableAnnotations repeatableAnnotations;
    DefaultConstructors defaultConstructors;
    Equality equality;
    SealedClasses sealedClasses;
    SealedInterfaces sealedInterfaces;

    public static void verify(ClassInfo clazz) {
        LangModelVerifier.ensureAssertionsEnabled();
        LangModelVerifier.ensureOnlyRuntimeAnnotations(clazz);
        AnnotatedTypes.verify(LangModelUtils.classOfField(clazz, "annotatedTypes"));
        AnnotatedSuperTypes.verify(LangModelUtils.classOfField(clazz, "annotatedSuperTypes"));
        AnnotatedThrowsTypes.verify(LangModelUtils.classOfField(clazz, "annotatedThrowsTypes"));
        AnnotatedReceiverTypes.verify(LangModelUtils.classOfField(clazz, "annotatedReceiverTypes"));
        AnnotationInstances.verify(LangModelUtils.classOfField(clazz, "annotationInstances"));
        PlainClassMembers.Verifier.verify(LangModelUtils.classOfField(clazz, "plainClassMembers"));
        InterfaceMembers.Verifier.verify(LangModelUtils.classOfField(clazz, "interfaceMembers"));
        AnnotationMembers.Verifier.verify(LangModelUtils.classOfField(clazz, "annotationMembers"));
        EnumMembers.Verifier.verify(LangModelUtils.classOfField(clazz, "enumMembers"));
        RecordMembers.Verifier.verify(LangModelUtils.classOfField(clazz, "recordMembers"));
        InheritedMethods.Verifier.verify(LangModelUtils.classOfField(clazz, "inheritedMethods"));
        InheritedFields.Verifier.verify(LangModelUtils.classOfField(clazz, "inheritedFields"));
        InheritedAnnotations.verify(LangModelUtils.classOfField(clazz, "inheritedAnnotations"));
        JavaLangObjectMethods.Verifier.verify(LangModelUtils.classOfField(clazz, "javaLangObjectMethods"));
        PrimitiveTypes.verify(LangModelUtils.classOfField(clazz, "primitiveTypes"));
        BridgeMethods.verify(LangModelUtils.classOfField(clazz, "bridgeMethods"));
        RepeatableAnnotations.verify(LangModelUtils.classOfField(clazz, "repeatableAnnotations"));
        DefaultConstructors.verify(LangModelUtils.classOfField(clazz, "defaultConstructors"));
        Equality.verify(LangModelUtils.classOfField(clazz, "equality"));
        SealedClasses.verify(LangModelUtils.classOfField(clazz, "sealedClasses"));
        SealedInterfaces.verify(LangModelUtils.classOfField(clazz, "sealedInterfaces"));
        LangModelVerifier.verifyPackageAnnotation(clazz);
        System.out.println(LangModelVerifier.class.getSimpleName() + " succeeded");
    }

    private static void ensureAssertionsEnabled() {
        boolean assertionsEnabled = false;
        try {
            assert (false);
        }
        catch (AssertionError ignored) {
            assertionsEnabled = true;
        }
        if (!assertionsEnabled) {
            throw new AssertionError((Object)"Assertions must be enabled to run the language model TCK");
        }
    }

    private static void ensureOnlyRuntimeAnnotations(ClassInfo clazz) {
        assert (!clazz.hasAnnotation(SourceAnnotation.class));
        assert (!clazz.hasAnnotation(ClassAnnotation.class));
        assert (clazz.hasAnnotation(RuntimeAnnotation.class));
    }

    private static void verifyPackageAnnotation(ClassInfo clazz) {
        PackageInfo pkg = clazz.packageInfo();
        assert (pkg.name().equals("org.jboss.cdi.lang.model.tck"));
        assert (pkg.annotations().size() == 1);
        assert (pkg.hasAnnotation(AnnPackage.class));
        assert (pkg.annotation(AnnPackage.class).hasValue());
        assert (pkg.annotation(AnnPackage.class).value().isString());
        assert (pkg.annotation(AnnPackage.class).value().asString().equals("lang-model-tck"));
        assert (pkg.repeatableAnnotation(AnnPackage.class).size() == 1);
        assert (!pkg.hasAnnotation(MissingAnnotation.class));
        assert (pkg.annotation(MissingAnnotation.class) == null);
        assert (pkg.repeatableAnnotation(MissingAnnotation.class).isEmpty());
    }
}

