/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.declarations.ClassInfo;
import org.jboss.cdi.lang.model.tck.LangModelUtils;
import org.jboss.cdi.lang.model.tck.SealedInterface;
import org.jboss.cdi.lang.model.tck.SealedInterfaceWithoutPermits;

public class SealedInterfaces {
    SealedInterface sealedInterface;
    SealedInterfaceWithoutPermits sealedInterfaceWithoutPermits;

    public static void verify(ClassInfo clazz) {
        SealedInterfaces.verifySealedInterface(LangModelUtils.classOfField(clazz, "sealedInterface"));
        SealedInterfaces.verifySealedInterfaceWithoutPermits(LangModelUtils.classOfField(clazz, "sealedInterfaceWithoutPermits"));
    }

    private static void verifySealedInterface(ClassInfo clazz) {
        assert (clazz.isInterface());
        assert (clazz.isAbstract());
        assert (!clazz.isFinal());
        assert (clazz.isSealed());
        assert (clazz.permittedSubclasses().size() == 2);
        block8: for (ClassInfo subclass : clazz.permittedSubclasses()) {
            switch (subclass.simpleName()) {
                case "SubinterfaceOfSealedInterface": {
                    assert (subclass.isInterface());
                    assert (!subclass.isFinal());
                    assert (subclass.isAbstract());
                    assert (!subclass.isSealed());
                    continue block8;
                }
                case "ImplementationOfSealedInterface": {
                    assert (subclass.isPlainClass());
                    assert (subclass.isFinal());
                    assert (!subclass.isAbstract());
                    assert (!subclass.isSealed());
                    continue block8;
                }
            }
            throw new AssertionError((Object)("Unexpected subclass " + subclass + " of " + clazz));
        }
    }

    private static void verifySealedInterfaceWithoutPermits(ClassInfo clazz) {
        assert (clazz.isInterface());
        assert (clazz.isAbstract());
        assert (!clazz.isFinal());
        assert (clazz.isSealed());
        assert (clazz.permittedSubclasses().size() == 2);
        block8: for (ClassInfo subclass : clazz.permittedSubclasses()) {
            switch (subclass.simpleName()) {
                case "SubinterfaceOfSealedInterfaceWithoutPermits": {
                    assert (subclass.isInterface());
                    assert (subclass.isAbstract());
                    assert (!subclass.isFinal());
                    assert (!subclass.isSealed());
                    continue block8;
                }
                case "ImplementationOfSealedInterfaceWithoutPermits": {
                    assert (subclass.isPlainClass());
                    assert (!subclass.isAbstract());
                    assert (subclass.isFinal());
                    assert (!subclass.isSealed());
                    continue block8;
                }
            }
            throw new AssertionError((Object)("Unexpected subclass " + subclass + " of " + clazz));
        }
    }
}

