/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.resource.persistenceContext;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.resource.persistenceContext.Database;
import org.jboss.cdi.tck.tests.implementation.simple.resource.persistenceContext.ManagedBean;
import org.jboss.cdi.tck.tests.implementation.simple.resource.persistenceContext.ServiceBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration", "persistence"})
@SpecVersion(spec="cdi", version="2.0")
public class PersistenceContextInjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(PersistenceContextInjectionTest.class)).withBeansXml("beans.xml")).withDefaultPersistenceXml()).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_resource", id="cc"), @SpecAssertion(section="resource_lifecycle", id="lb"), @SpecAssertion(section="resource_lifecycle", id="mc")})
    public void testInjectionOfPersistenceContext() {
        ServiceBean serviceBean = this.getContextualReference(ServiceBean.class, new Annotation[0]);
        ManagedBean managedBean = serviceBean.getManagedBean();
        assert (managedBean.getPersistenceContext() != null) : "Persistence context was not injected into bean";
        assert (serviceBean.validateEntityManager());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_resource", id="dd"), @SpecAssertion(section="resource_lifecycle", id="lc"), @SpecAssertion(section="resource_lifecycle", id="me")})
    public void testInjectionOfPersistenceUnit() {
        Bean<ManagedBean> managedBeanBean = this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext managedBeanCc = this.getCurrentManager().createCreationalContext(managedBeanBean);
        ManagedBean managedBean = (ManagedBean)managedBeanBean.create(managedBeanCc);
        assert (managedBean.getPersistenceUnit() != null) : "Persistence unit was not injected into bean";
        assert (managedBean.getPersistenceUnit().isOpen()) : "Persistence unit not open injected into bean";
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_lifecycle", id="md")})
    public void testPassivationOfPersistenceContext() throws Exception {
        Bean<ManagedBean> managedBeanBean = this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext managedBeanCc = this.getCurrentManager().createCreationalContext(managedBeanBean);
        ManagedBean managedBean = (ManagedBean)managedBeanBean.create(managedBeanCc);
        managedBean = (ManagedBean)this.activate(this.passivate(managedBean));
        assert (managedBean.getPersistenceContext() != null) : "Persistence context was not injected into bean";
        assert (managedBean.getPersistenceContext().getDelegate() != null) : "Persistence context not deserialized correctly";
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_lifecycle", id="lc"), @SpecAssertion(section="resource_lifecycle", id="mf")})
    public void testPassivationOfPersistenceUnit() throws Exception {
        Bean<ManagedBean> managedBeanBean = this.getBeans(ManagedBean.class, new Annotation[0]).iterator().next();
        CreationalContext managedBeanCc = this.getCurrentManager().createCreationalContext(managedBeanBean);
        ManagedBean managedBean = (ManagedBean)managedBeanBean.create(managedBeanCc);
        managedBean = (ManagedBean)this.activate(this.passivate(managedBean));
        assert (managedBean.getPersistenceUnit() != null) : "Persistence unit was not injected into bean";
        assert (managedBean.getPersistenceUnit().isOpen()) : "Persistence unit not open injected into bean";
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_resource", id="hh"), @SpecAssertion(section="resource_types", id="ab")})
    public void testBeanTypesAndBindingTypesOfPersistenceContext() {
        Bean<EntityManager> manager = this.getBeans(EntityManager.class, new Annotation[]{new AnnotationLiteral<Database>(){}}).iterator().next();
        assert (manager.getTypes().size() == 2);
        assert (this.typeSetMatches(manager.getTypes(), new Type[]{EntityManager.class, Object.class}));
        assert (manager.getQualifiers().size() == 2);
        assert (this.annotationSetMatches((Set<? extends Annotation>)manager.getQualifiers(), Any.class, Database.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_types", id="ac")})
    public void testBeanTypesOfPersistenceUnit() {
        Bean<EntityManagerFactory> factory = this.getBeans(EntityManagerFactory.class, new Annotation[]{new AnnotationLiteral<Database>(){}}).iterator().next();
        assert (factory.getTypes().size() == 2);
        assert (this.typeSetMatches(factory.getTypes(), new Type[]{EntityManagerFactory.class, Object.class}));
    }
}

