/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.atd;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.literal.InjectLiteral;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.BravoInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.DeltaAlternative;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.DeltaAlternativeBean;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.DeltaDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.DeltaDecoratorBean;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.DeltaInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.DeltaInterceptorBean;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Bar;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Baz;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Boss;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Foo;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Pro;

public class AfterTypeDiscoveryObserver
implements Extension {
    private List<Class<?>> interceptors = null;
    private List<Class<?>> alternatives = null;
    private List<Class<?>> decorators = null;
    private boolean bossObserved = false;
    private boolean processProducerEventFiredForProducerMethod = false;
    private boolean processProducerEventFiredForProducerField = false;
    private DeltaAlternativeBean deltaAlternative = new DeltaAlternativeBean();
    private DeltaInterceptorBean deltaInterceptor = new DeltaInterceptorBean();
    private DeltaDecoratorBean deltaDecorator;

    public void observeAfterTypeDiscovery(@Observes AfterTypeDiscovery event, BeanManager beanManager) {
        event.getAlternatives().add(DeltaAlternative.class);
        event.getInterceptors().add(DeltaInterceptor.class);
        event.getDecorators().add(DeltaDecorator.class);
        this.interceptors = Collections.unmodifiableList(new ArrayList(event.getInterceptors()));
        this.alternatives = Collections.unmodifiableList(new ArrayList(event.getAlternatives()));
        this.decorators = Collections.unmodifiableList(new ArrayList(event.getDecorators()));
        event.addAnnotatedType(beanManager.createAnnotatedType(Boss.class), AfterTypeDiscoveryObserver.class.getName());
        Iterator iterator = event.getInterceptors().iterator();
        while (iterator.hasNext()) {
            if (!BravoInterceptor.class.equals(iterator.next())) continue;
            iterator.remove();
        }
        Collections.reverse(event.getDecorators());
        event.getAlternatives().remove(0);
        ((AnnotatedFieldConfigurator)event.addAnnotatedType(Baz.class, AfterTypeDiscoveryObserver.class.getName() + ":" + Baz.class.getName()).add((Annotation)Pro.ProLiteral.INSTANCE).add((Annotation)RequestScoped.Literal.INSTANCE).filterFields(annotatedField -> annotatedField.getJavaMember().getType().equals(Instance.class)).findFirst().get()).add((Annotation)InjectLiteral.INSTANCE).add((Annotation)Pro.ProLiteral.INSTANCE);
    }

    public void observeAfterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        AnnotatedType type = beanManager.createAnnotatedType(DeltaDecorator.class);
        this.deltaDecorator = new DeltaDecoratorBean((AnnotatedField<? super DeltaDecorator>)((AnnotatedField)type.getFields().iterator().next()), beanManager);
        event.addBean((Bean)this.deltaAlternative);
        event.addBean((Bean)this.deltaInterceptor);
        event.addBean((Bean)this.deltaDecorator);
    }

    public void observeProcessAnnotatedType(@Observes ProcessAnnotatedType<DeltaDecorator> event) {
        event.veto();
    }

    public void observeBossAnnotatedType(@Observes ProcessAnnotatedType<Boss> event) {
        this.bossObserved = true;
    }

    public void observeProcessProducerForProducerField(@Observes ProcessProducer<Boss, Foo> event) {
        this.processProducerEventFiredForProducerField = true;
    }

    public void observeProcessProducerForProducerMethod(@Observes ProcessProducer<Boss, Bar> event) {
        this.processProducerEventFiredForProducerMethod = true;
    }

    public List<Class<?>> getInterceptors() {
        return this.interceptors;
    }

    public List<Class<?>> getAlternatives() {
        return this.alternatives;
    }

    public List<Class<?>> getDecorators() {
        return this.decorators;
    }

    public boolean isBossObserved() {
        return this.bossObserved;
    }

    public boolean isProcessProcuderFieldObserved() {
        return this.processProducerEventFiredForProducerField;
    }

    public boolean isProcessProcuderMethodObserved() {
        return this.processProducerEventFiredForProducerMethod;
    }
}

