/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session.event;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.event.Observes;
import jakarta.servlet.http.HttpSession;
import java.util.concurrent.atomic.AtomicInteger;

@ApplicationScoped
public class ObservingBean {
    private final AtomicInteger initializedSessionCount = new AtomicInteger();
    private final AtomicInteger beforedDestroyedSessionCount = new AtomicInteger();
    private final AtomicInteger destroyedSessionCount = new AtomicInteger();

    public void observeSessionInitialized(@Observes @Initialized(value=SessionScoped.class) HttpSession event) {
        this.initializedSessionCount.incrementAndGet();
    }

    public void observeSessionBeforeDestroyed(@Observes @BeforeDestroyed(value=SessionScoped.class) HttpSession event) {
        this.beforedDestroyedSessionCount.incrementAndGet();
    }

    public void observeSessionDestroyed(@Observes @Destroyed(value=SessionScoped.class) HttpSession event) {
        this.destroyedSessionCount.incrementAndGet();
    }

    public AtomicInteger getInitializedSessionCount() {
        return this.initializedSessionCount;
    }

    public AtomicInteger getBeforedDestroyedSessionCount() {
        return this.beforedDestroyedSessionCount;
    }

    public AtomicInteger getDestroyedSessionCount() {
        return this.destroyedSessionCount;
    }
}

