/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.client.clientrequestcontext;

import ee.jakarta.tck.ws.rs.api.client.clientrequestcontext.ContextProvider;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

public class GetPropertyNamesProvider
extends ContextProvider {
    private AtomicInteger counter;

    public GetPropertyNamesProvider(AtomicInteger counter) {
        this.counter = counter;
    }

    @Override
    protected void checkFilterContext(ClientRequestContext context) throws JAXRSCommonClient.Fault {
        if (this.counter.incrementAndGet() == 2) {
            Collection properties = context.getPropertyNames();
            String entity = properties == null ? "NULL" : JaxrsUtil.iterableToString(";", properties);
            Response r = Response.ok((Object)entity).build();
            context.abortWith(r);
        } else {
            context.setProperty("PROPERTY1", (Object)"value1");
            context.setProperty("PROPERTY2", (Object)"value2");
        }
    }

    protected static <T> String collectionToString(Collection<T> collection) {
        StringBuilder sb = new StringBuilder();
        for (T t : collection) {
            sb.append(t).append(";");
        }
        return sb.toString();
    }
}

