/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.constrainedto;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.constrainedto.ClientSideReader;
import ee.jakarta.tck.ws.rs.ee.rs.constrainedto.ClientSideWriter;
import ee.jakarta.tck.ws.rs.ee.rs.constrainedto.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.constrainedto.ServerSideReader;
import ee.jakarta.tck.ws.rs.ee.rs.constrainedto.ServerSideWriter;
import ee.jakarta.tck.ws.rs.ee.rs.constrainedto.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 3343257931794865470L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_constrainedto_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/constrainedto/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_constrainedto_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, ClientSideReader.class, ClientSideWriter.class, ServerSideReader.class, ServerSideWriter.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void serverSideReaderIsUsedOnServerTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "Anything");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "The fake reader on server side");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(ServerSideReader.MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void clientSideReaderIsNotUsedOnServerTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "ConstrainedTo message");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ConstrainedTo message");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(ClientSideReader.MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void serverSideWriterIsUsedOnServerTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "ConstrainedTo message");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "The fake writer on server side");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(ServerSideWriter.MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void clientSideWriterIsNotUsedOnServerTest() throws JAXRSCommonClient.Fault {
        this.setPrintEntity(true);
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "ConstrainedTo message");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ConstrainedTo message");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(ClientSideWriter.MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void serverSideReaderIsNotUsedOnClientTest() throws JAXRSCommonClient.Fault {
        this.addProviders();
        this.setProperty(JAXRSCommonClient.Property.CONTENT, ServerSideReader.MEDIA_TYPE.toString());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ConstrainedTo message");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "media"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.invoke();
    }

    @Test
    public void clientSideReaderIsUsedOnClientTest() throws JAXRSCommonClient.Fault {
        this.addProviders();
        this.setProperty(JAXRSCommonClient.Property.CONTENT, ClientSideReader.MEDIA_TYPE.toString());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "The fake reader on client side");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "media"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.invoke();
    }

    @Test
    public void serverSideWriterIsNotUsedOnClientTest() throws JAXRSCommonClient.Fault {
        this.addProviders();
        this.setProperty(JAXRSCommonClient.Property.CONTENT, ServerSideWriter.MEDIA_TYPE.toString());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ConstrainedTo message");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "media"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.invoke();
    }

    @Test
    public void clientSideWriterIsUsedOnClientTest() throws JAXRSCommonClient.Fault {
        this.addProviders();
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "ConstrainedTo message");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "clientwriter"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(ClientSideWriter.MEDIA_TYPE));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }

    protected void addProviders() {
        this.addProvider(ServerSideReader.class);
        this.addProvider(ClientSideReader.class);
        this.addProvider(ServerSideWriter.class);
        this.addProvider(ClientSideWriter.class);
    }
}

