/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.link;

import ee.jakarta.tck.ws.rs.api.rs.core.link.Resource;
import ee.jakarta.tck.ws.rs.api.rs.core.link.ResourceWithProduces;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -373684847397542733L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest() throws JAXRSCommonClient.Fault {
        Link link = new Link(){

            public URI getUri() {
                return null;
            }

            public UriBuilder getUriBuilder() {
                return null;
            }

            public String getRel() {
                return null;
            }

            public List<String> getRels() {
                return null;
            }

            public String getTitle() {
                return null;
            }

            public String getType() {
                return null;
            }

            public Map<String, String> getParams() {
                return null;
            }

            public String toString() {
                return "";
            }
        };
        Assertions.assertTrue((link != null ? 1 : 0) != 0, (String)"new Link() is null");
        JAXRSClientIT.logMsg("new Link() call iss successfull", link.toString());
    }

    @Test
    public void fromMethodTest() throws JAXRSCommonClient.Fault {
        Link link = JAXRSClientIT.linkFromResource("consumesAppJson");
        String resource = link.toString();
        this.assertContains(resource, "<consumesappjson>");
        JAXRSClientIT.logMsg("Link", resource, "has been created");
    }

    @Test
    public void fromResourceMethodLinkUsedInInvocationTest() throws JAXRSCommonClient.Fault {
        String linkName = "link";
        Client client = ClientBuilder.newClient();
        client.register((Object)new ClientRequestFilter(){

            public void filter(ClientRequestContext ctx) throws IOException {
                String uri = ctx.getUri().toASCIIString();
                Link.Builder builder = Link.fromMethod(Resource.class, (String)"consumesAppJson").rel("link");
                Link link = builder.build(new Object[0]);
                Response response = Response.ok((Object)uri).links(new Link[]{link}).build();
                ctx.abortWith(response);
            }
        });
        WebTarget target = client.target(JAXRSClientIT.url() + "resource/get");
        Response response = target.request().get();
        String entity = (String)response.readEntity(String.class);
        Assertions.assertTrue((boolean)response.hasLink("link"), (String)"No link received");
        this.assertContains(JAXRSClientIT.url() + "resource/get", entity);
        Assertions.assertTrue((boolean)response.hasLink("link"), (String)"No link received");
        Link link = response.getLink("link");
        response = client.invocation(link).post(null);
        entity = (String)response.readEntity(String.class);
        Assertions.assertTrue((boolean)response.hasLink("link"), (String)"No link received");
        this.assertContains(JAXRSClientIT.url() + "resource/consumesappjson", entity);
        JAXRSClientIT.logMsg("Opaque Link has been used in Client.invocation() sucessfully");
    }

    @Test
    public void fromResourceMethodThrowsIllegalArgumentExceptionNoMethodTest() throws JAXRSCommonClient.Fault {
        try {
            JAXRSClientIT.linkFromResource("nonexistingMethod");
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException iae) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been successfully thrown");
            return;
        }
    }

    @Test
    public void fromResourceMethodThrowsIllegalArgumentExceptionNullMethodTest() throws JAXRSCommonClient.Fault {
        try {
            JAXRSClientIT.linkFromResource(null);
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException iae) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been successfully thrown");
            return;
        }
    }

    @Test
    public void fromResourceMethodThrowsIllegalArgumentExceptionNullClassTest() throws JAXRSCommonClient.Fault {
        try {
            Link.fromMethod(null, (String)"anymethod");
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException iae) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been successfully thrown");
            return;
        }
    }

    @Test
    public void fromUriTest() throws JAXRSCommonClient.Fault {
        URI uri = this.uri(JAXRSCommonClient.Request.GET.name());
        Link.Builder builder = Link.fromUri((URI)uri);
        Link link = builder.build(new Object[0]);
        this.assertContains(link.toString(), JAXRSClientIT.url());
        this.assertContains(link.toString(), "resource");
        this.assertContains(link.toString(), "get");
        JAXRSClientIT.logMsg("Link", link, "has been created from URI", uri);
    }

    @Test
    public void fromUriThrowsIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            Link.fromUri((URI)null);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgument has been thrown as expected:", e);
            return;
        }
        throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
    }

    @Test
    public void fromUriStringTest() throws JAXRSCommonClient.Fault {
        URI uri = this.uri(JAXRSCommonClient.Request.GET.name());
        Link.Builder builder = Link.fromUri((String)uri.toASCIIString());
        Link link = builder.build(new Object[0]);
        this.assertContains(link.toString(), JAXRSClientIT.url());
        this.assertContains(link.toString(), "resource");
        this.assertContains(link.toString(), "get");
        JAXRSClientIT.logMsg("Link", link, "has been created from URI", uri.toASCIIString());
    }

    @Test
    public void fromUriStringThrowsIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            Link.fromUri((String)null);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgument has been thrown as expected:", e);
            return;
        }
        throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
    }

    @Test
    public void getParamsFromResourceTest() throws JAXRSCommonClient.Fault {
        String title = "Title";
        Link link = Link.fromMethod(Resource.class, (String)"producesSvgXml").title(title).build(new Object[0]);
        Map params = link.getParams();
        System.out.println(params);
        String value = (String)params.get("type");
        JAXRSClientIT.assertNull(value, "Unexpected media type in link found", value);
        value = (String)params.get("title");
        this.assertContains(value, title);
        JAXRSClientIT.logMsg(params, "found as expected");
    }

    @Test
    public void getParamsFromBuilderTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = Link.fromUri((URI)this.uri("get"));
        builder.rel("RELREL").title("TITLETITLE").type("TYPETYPE").param("NEWPARAM", "NEWPARAMVALUE");
        Link link = builder.build(new Object[0]);
        Map params = link.getParams();
        String value = (String)params.get("title");
        this.assertContains(value, "titletitle");
        value = (String)params.get("rel");
        this.assertContains(value, "RELREL");
        value = (String)params.get("type");
        this.assertContains(value, "typetype");
        value = (String)params.get("NEWPARAM");
        this.assertContains(value, "newparamvalue");
        JAXRSClientIT.logMsg(params, "found as expected");
    }

    @Test
    public void getRelTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = Link.fromUri((URI)this.uri("get"));
        builder.rel("RELREL").title("TITLETITLE").type("TYPETYPE").param("NEWPARAM", "NEWPARAMVALUE");
        Link link = builder.build(new Object[0]);
        String rel = link.getRel();
        Assertions.assertTrue((boolean)rel.contains("RELREL"), (String)"#getRel did NOT return expected RELREL");
        JAXRSClientIT.logMsg("#getRel() return expected rel");
    }

    @Test
    public void getRelIsEmptyListTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = Link.fromUri((URI)this.uri("get"));
        Link link = builder.build(new Object[0]);
        String rel = link.getRel();
        Assertions.assertTrue((rel == null ? 1 : 0) != 0, (String)"#getRel is NOT null");
        JAXRSClientIT.logMsg("#getRel() returns expected null");
    }

    @Test
    public void getTitleTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = Link.fromUri((URI)this.uri("get"));
        builder.rel("RELREL").title("TITLETITLE").type("TYPETYPE");
        Link link = builder.build(new Object[0]);
        String title = link.getTitle();
        Assertions.assertTrue((title != null ? 1 : 0) != 0, (String)"#getTitle did NOT return expected title");
        this.assertContains(title, "TITLETITLE");
    }

    @Test
    public void getTitleIsNullTest() throws JAXRSCommonClient.Fault {
        Link link = JAXRSClientIT.linkFromResource("get");
        String title = link.getTitle();
        Assertions.assertTrue((title == null ? 1 : 0) != 0, (String)("#getTitle is unexpected " + title));
        JAXRSClientIT.logMsg("#getTitle( returns null as expected");
    }

    @Test
    public void getTypeTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = Link.fromUri((URI)this.uri("get"));
        builder.rel("RELREL").title("TITLETITLE").type("TYPETYPE");
        Link link = builder.build(new Object[0]);
        String type = link.getType();
        Assertions.assertTrue((type != null ? 1 : 0) != 0, (String)"#getType() did NOT return expected title");
        this.assertContains(type, "TYPETYPE");
    }

    @Test
    public void getTypeIsNullTest() throws JAXRSCommonClient.Fault {
        Link link = JAXRSClientIT.linkFromResource("get");
        String type = link.getType();
        Assertions.assertTrue((type == null ? 1 : 0) != 0, (String)("#getType is unexpected " + type));
        JAXRSClientIT.logMsg("#getType( returns null as expected");
    }

    @Test
    public void getUriTest() throws JAXRSCommonClient.Fault {
        URI uri = this.uri("get");
        Link.Builder builder = Link.fromUri((URI)uri);
        Link link = builder.build(new Object[0]);
        URI uriFromLink = link.getUri();
        Assertions.assertTrue((boolean)uri.equals(uriFromLink), (String)("#getUri() " + uriFromLink + " differes from original uri " + uri));
        JAXRSClientIT.logMsg("Original URI", uri, "equals obtained", uriFromLink);
    }

    @Test
    public void getUriBuilderTest() throws JAXRSCommonClient.Fault {
        URI uri = this.uri("get");
        Link.Builder builder = Link.fromUri((URI)uri);
        Link link = builder.build(new Object[0]);
        UriBuilder uriBuilder = link.getUriBuilder();
        Assertions.assertTrue((uriBuilder != null ? 1 : 0) != 0, (String)"#getUriBuilder is null");
        URI uriFromLink = uriBuilder.build(new Object[0]);
        Assertions.assertTrue((boolean)uri.equals(uriFromLink), (String)("#getUri() " + uriFromLink + " differes from original uri " + uri));
        JAXRSClientIT.logMsg("Original URI", uri, "equals obtained", uriFromLink);
    }

    @Test
    public void serializationFromResourceTest() throws JAXRSCommonClient.Fault {
        Method[] methods;
        for (Method method : methods = Resource.class.getDeclaredMethods()) {
            JAXRSClientIT.logMsg("Serialization for method", method);
            String name = method.getName();
            Link link = JAXRSClientIT.linkFromResource(name);
            String string = link.toString();
            Link fromValueOf = Link.valueOf((String)string);
            JAXRSClientIT.assertEquals(link.toString(), fromValueOf.toString(), "links", link, fromValueOf, "are not equal");
            JAXRSClientIT.logMsg("serialization works for method", name);
        }
        JAXRSClientIT.logMsg("Serialization with #toString() of Resource method links is sucessfull");
    }

    @Test
    public void valueOfThrowsIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            Link.valueOf((String)"</>>");
            throw new JAXRSCommonClient.Fault("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("Link#vaueOf() throws IllegalArgumentException as expected");
            return;
        }
    }

    @Test
    public void getRelsTest() throws JAXRSCommonClient.Fault {
        String[] rels = new String[]{"RELREL", "REL", "relrelrel", "RELRELREL"};
        Link.Builder builder = Link.fromUri((URI)this.uri("get"));
        for (int i = 0; i != rels.length; ++i) {
            builder = builder.rel(rels[i]);
        }
        Link link = builder.build(new Object[0]);
        JAXRSClientIT.assertNotNull(link.getRels(), "#getRels is null");
        JAXRSClientIT.assertEqualsInt(link.getRels().size(), 4, "Unexpected #getRels size", link.getRels().size(), "Should be 4");
        String list = ";" + JaxrsUtil.iterableToString(";", link.getRels()) + ";";
        for (int i = 0; i != rels.length; ++i) {
            JAXRSClientIT.assertContains(list, ";" + rels[i] + ";", new Object[]{"Relation", rels[i], "has not been found in #getRels", list});
        }
        JAXRSClientIT.logMsg("#getRel() return expected rels", list);
    }

    @Test
    public void getRelsIsEmptyTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = Link.fromUri((URI)this.uri("get"));
        Link link = builder.build(new Object[0]);
        JAXRSClientIT.assertNotNull(link.getRels(), "#getRels is null");
        JAXRSClientIT.assertEqualsInt(link.getRels().size(), 0, "Unexpected #getRels size", link.getRels().size(), "Should be 0");
        JAXRSClientIT.logMsg("#getRel() return empty list as expected");
    }

    @Test
    public void fromResourceTest() throws JAXRSCommonClient.Fault {
        Link link = Link.fromResource(Resource.class).build(new Object[0]);
        String resource = link.toString();
        this.assertContains(resource, "<resource>");
        this.assertNotContains(resource, "type");
        JAXRSClientIT.logMsg("Link", resource, "has been created");
    }

    @Test
    public void fromResourceWithMediaTypeTest() throws JAXRSCommonClient.Fault {
        Link link = Link.fromResource(ResourceWithProduces.class).build(new Object[0]);
        String resource = link.toString();
        this.assertContains(resource, "<producesresource>");
        this.assertNotContains(resource, "type=\"text/html\"");
        JAXRSClientIT.logMsg("Link", resource, "has been created");
    }

    @Test
    public void fromResourceThrowsIAEWhenNullClassTest() throws JAXRSCommonClient.Fault {
        try {
            Link link = Link.fromResource((Class)null).build(new Object[0]);
            JAXRSClientIT.logMsg("Unexpectedly thrown no exception and created link", link);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected", e);
        }
    }

    @Test
    public void fromUriBuilderTest() throws JAXRSCommonClient.Fault {
        String segment = "goto/label/ten/";
        Link link = Link.fromUri((URI)this.uri(segment)).build(new Object[0]);
        UriBuilder builder = link.getUriBuilder();
        Link.Builder fromBuilder = Link.fromUriBuilder((UriBuilder)builder);
        String sBuilder = builder.build(new Object[0]).toASCIIString();
        String sFromBuilder = fromBuilder.build(new Object[0]).getUri().toASCIIString();
        JAXRSClientIT.assertContains(sFromBuilder, sBuilder, new Object[]{"Original builder", sBuilder, "not found in #fromUriBuilder", sFromBuilder});
        JAXRSClientIT.logMsg("#fromUriBuilder", sFromBuilder, "contains the original", sBuilder);
    }

    @Test
    public void fromPathTest() throws JAXRSCommonClient.Fault {
        String path = "somewhere/somehow";
        UriBuilder builder = UriBuilder.fromPath((String)path);
        Link.Builder linkBuilder = Link.fromUriBuilder((UriBuilder)builder);
        Link.Builder fromPathBuilder = Link.fromPath((String)path);
        String fromUriBuilderString = linkBuilder.build(new Object[0]).toString();
        String fromPathString = fromPathBuilder.build(new Object[0]).toString();
        JAXRSClientIT.assertEquals(fromUriBuilderString, fromPathString, "fromUriBuilder()=", fromUriBuilderString, "differs from Link.fromPath()", fromPathString);
        JAXRSClientIT.logMsg("fromUriBuilder(UriBuilder.fromPath(path)) is equivalent to fromPath(path)", "The link is", fromPathString);
    }

    @Test
    public void fromPathWithUriTemplateParamsTest() throws JAXRSCommonClient.Fault {
        String path = "somewhere/somehow/{p1}/{p2}";
        String param1 = "param1";
        String param2 = "param2";
        UriBuilder builder = UriBuilder.fromPath((String)path);
        Link.Builder linkBuilder = Link.fromUriBuilder((UriBuilder)builder);
        Link.Builder fromPathBuilder = Link.fromPath((String)path);
        String fromUriBuilderString = linkBuilder.build(new Object[]{param1, param2}).toString();
        String fromPathString = fromPathBuilder.build(new Object[]{param1, param2}).toString();
        JAXRSClientIT.assertEquals(fromUriBuilderString, fromPathString, "fromUriBuilder(UriBuilder.fromPath(,", path, "))=", fromUriBuilderString, "differs from Link.fromPath(", path, ")", fromPathString);
        JAXRSClientIT.logMsg("fromUriBuilder(UriBuilder.fromPath(", path, ")) is equivalent to fromPath(", path, ")", "The link is", fromPathString);
    }

    @Test
    public void fromPathThrowsIAETest() throws JAXRSCommonClient.Fault {
        try {
            UriBuilder.fromPath((String)null);
            JAXRSClientIT.fault("fromPath(null) does not throws IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("fromPath(null) throws IllegalArgumentException as expected");
        }
    }

    @Test
    public void fromLinkTest() throws JAXRSCommonClient.Fault {
        Link link = RuntimeDelegate.getInstance().createLinkBuilder().baseUri(JAXRSClientIT.url()).rel("relation relation2").title("titleX").param("param1", "value1").param("param2", "value2").type("application/octet-stream").build(new Object[0]);
        Link fromLink = Link.fromLink((Link)link).build(new Object[0]);
        JAXRSClientIT.assertEquals(link, fromLink, "fromLink(link)=", fromLink, "differes from original Link", link);
        JAXRSClientIT.logMsg("fromLink() is equal to original link", link, "as expected");
    }

    protected static Link linkFromResource(String method) {
        Link.Builder builder = Link.fromMethod(Resource.class, (String)method);
        Link link = builder.build(new Object[0]);
        return link;
    }

    protected void assertContains(String string, String substring) throws JAXRSCommonClient.Fault {
        JAXRSCommonClient.assertContainsIgnoreCase(string, substring, new Object[]{string, "does not contain expected", substring});
        JAXRSClientIT.logMsg("Found expected", substring);
    }

    protected void assertNotContains(String string, String substring) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((!string.toLowerCase().contains(substring.toLowerCase()) ? 1 : 0) != 0, (String)(string + " does unexpectedly contain " + substring));
        JAXRSClientIT.logMsg(substring, "is not in", string, "as expected");
    }

    protected URI uri(String method) throws JAXRSCommonClient.Fault {
        URI uri = null;
        try {
            uri = new URI(JAXRSClientIT.url() + "resource/" + method);
        }
        catch (URISyntaxException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        return uri;
    }

    protected static String url() {
        return "http://oracle.com:888/";
    }
}

