/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.security;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.security.RequestFilter;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.security.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.container.requestcontext.security.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = -3020219607348263568L;
    protected String user;
    protected String password;

    public JAXRSClientIT() {
        this.usersetup();
        this.setContextRoot("/jaxrs_ee_rs_container_requestcontext_security_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/container/requestcontext/security/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_container_requestcontext_security_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, RequestFilter.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    public void usersetup() {
        this.user = System.getProperty("user");
        this.password = System.getProperty("password");
        Assertions.assertTrue((!this.isNullOrEmpty(this.user) ? 1 : 0) != 0, (String)"user not set");
        Assertions.assertTrue((!this.isNullOrEmpty(this.password) ? 1 : 0) != 0, (String)"password not set");
        super.setup();
    }

    @RunAsClient
    @Test
    @Tag(value="security")
    public void getSecurityContextTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.BASIC_AUTH_USER, this.user);
        this.setProperty(JAXRSCommonClient.Property.BASIC_AUTH_PASSWD, this.password);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, this.user);
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.invoke();
    }

    @RunAsClient
    @Test
    @Tag(value="security")
    public void noSecurityTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.UNAUTHORIZED));
        this.invoke();
    }
}

