/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.KnownFailuresList;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.KflSorter;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.SortedSet;

class KflSection
extends HTMLSection {
    static final String FAIL2PASS = "kfl_fail2pass.html";
    static final String FAIL2ERROR = "kfl_fail2error.html";
    static final String FAIL2MISSING = "kfl_fail2missing.html";
    static final String FAIL2NOTRUN = "kfl_fail2notrun.html";
    static final String FAIL2FAIL = "kfl_fail2fail.html";
    static final String NEWFAILURES = "kfl_newfailures.html";
    static final String OTHER_ERRORS = "kfl_otherErrors.html";
    static final String TC_FAIL2PASS = "kfl_tc_fail2pass.html";
    static final String TC_FAIL2ERROR = "kfl_tc_fail2error.html";
    static final String TC_FAIL2MISSING = "kfl_tc_fail2missing.html";
    static final String TC_FAIL2NOTRUN = "kfl_tc_fail2notrun.html";
    static final String TC_NEWFAILURES = "kfl_tc_newfailures.html";
    private final I18NResourceBundle i18n;
    private TestResultTable resultTable;
    private KflSorter sorter;
    private KnownFailuresList kfl;

    KflSection(HTMLReport parent, ReportSettings settings, File dir, I18NResourceBundle i18n, KflSorter data) {
        super(i18n.getString("kfl.title"), settings, dir, parent);
        this.i18n = i18n;
        this.sorter = data;
        this.resultTable = settings.getInterview().getWorkDirectory().getTestResultTable();
        this.kfl = settings.getInterview().getKnownFailuresList();
        i18n.getString("kfl.f2e.heading");
        i18n.getString("kfl.f2e.notes");
        i18n.getString("kfl.f2e.title");
        i18n.getString("kfl.f2m.heading");
        i18n.getString("kfl.f2m.notes");
        i18n.getString("kfl.f2m.title");
        i18n.getString("kfl.f2nr.heading");
        i18n.getString("kfl.f2nr.notes");
        i18n.getString("kfl.f2nr.title");
        i18n.getString("kfl.f2p.heading");
        i18n.getString("kfl.f2p.notes");
        i18n.getString("kfl.f2p.title");
        i18n.getString("kfl.new.heading");
        i18n.getString("kfl.new.notes");
        i18n.getString("kfl.new.title");
        i18n.getString("kfl.errors.heading");
        i18n.getString("kfl.errors.notes");
        i18n.getString("kfl.errors.title");
        i18n.getString("kfl.f2f.heading");
        i18n.getString("kfl.f2f.notes");
        i18n.getString("kfl.f2f.title");
        i18n.getString("kfl.tc_f2e.heading");
        i18n.getString("kfl.tc_f2e.notes");
        i18n.getString("kfl.tc_f2e.summary");
        i18n.getString("kfl.tc_f2e.title");
        i18n.getString("kfl.tc_f2m.heading");
        i18n.getString("kfl.tc_f2m.notes");
        i18n.getString("kfl.tc_f2m.summary");
        i18n.getString("kfl.tc_f2m.title");
        i18n.getString("kfl.tc_f2nr.heading");
        i18n.getString("kfl.tc_f2nr.notes");
        i18n.getString("kfl.tc_f2nr.summary");
        i18n.getString("kfl.tc_f2nr.title");
        i18n.getString("kfl.tc_f2p.heading");
        i18n.getString("kfl.tc_f2p.notes");
        i18n.getString("kfl.tc_f2p.summary");
        i18n.getString("kfl.tc_f2p.title");
        i18n.getString("kfl.tc_new.heading");
        i18n.getString("kfl.tc_new.notes");
        i18n.getString("kfl.tc_new.summary");
        i18n.getString("kfl.tc_new.title");
    }

    @Override
    void writeSummary(ReportWriter repWriter) throws IOException {
        super.writeSummary(repWriter);
        repWriter.write(this.i18n.getString("kfl.files.list"));
        File[] kfls = this.settings.getInterview().getKnownFailureFiles();
        if (kfls != null && kfls.length > 0) {
            repWriter.startTag("ul");
            for (File f : kfls) {
                repWriter.startTag("li");
                repWriter.writeLink(f.toURI().toString(), f.getCanonicalPath());
            }
        } else {
            repWriter.write(this.i18n.getString("kfl.nofiles"));
            repWriter.newLine();
            return;
        }
        repWriter.endTag("ul");
        if (this.kfl == null) {
            repWriter.write(this.i18n.getString("kfl.unable"));
            repWriter.startTag("br");
            repWriter.newLine();
            return;
        }
        repWriter.startTag("table");
        repWriter.writeAttr("border", 1);
        repWriter.startTag("tr");
        repWriter.writeTH(this.i18n.getString("kfl.changes.hdr"), "row");
        repWriter.writeTH(this.i18n.getString("kfl.tests.hdr", (Object)Integer.toString(this.sorter.getErrorCount())), "row");
        if (this.settings.isKflTestCasesEnabled()) {
            repWriter.writeTH(this.i18n.getString("kfl.tc.hdr", (Object)Integer.toString(this.sorter.getTestCasesErrorCount())), "row");
        }
        repWriter.startTag("tr");
        repWriter.writeTH(this.i18n.getString("kfl.f2p.summary"), "row");
        repWriter.startTag("td");
        repWriter.writeLink(FAIL2PASS, Integer.toString(this.sorter.getSet(KflSorter.Transitions.FAIL2PASS).size()));
        repWriter.endTag("td");
        if (this.settings.isKflTestCasesEnabled()) {
            repWriter.startTag("td");
            repWriter.writeLink(TC_FAIL2PASS, Integer.toString(this.sorter.getSet(KflSorter.Transitions.TC_FAIL2PASS).size()));
            repWriter.endTag("td");
        }
        if (this.settings.isKflF2eEnabled()) {
            repWriter.startTag("tr");
            repWriter.writeTH(this.i18n.getString("kfl.f2e.summary"), "row");
            repWriter.startTag("td");
            repWriter.writeLink(FAIL2ERROR, Integer.toString(this.sorter.getSet(KflSorter.Transitions.FAIL2ERROR).size()));
            repWriter.endTag("td");
            if (this.settings.isKflTestCasesEnabled()) {
                repWriter.startTag("td");
                repWriter.writeLink(TC_FAIL2ERROR, Integer.toString(this.sorter.getSet(KflSorter.Transitions.TC_FAIL2ERROR).size()));
                repWriter.endTag("td");
            }
        }
        repWriter.startTag("tr");
        repWriter.writeTH(this.i18n.getString("kfl.errors.summary"), "row");
        repWriter.startTag("td");
        repWriter.writeLink(OTHER_ERRORS, Integer.toString(this.sorter.getSet(KflSorter.Transitions.OTHER_ERRORS).size()));
        repWriter.endTag("td");
        repWriter.startTag("td");
        repWriter.write(this.i18n.getString("kfl.f2f.notc"));
        repWriter.endTag("td");
        repWriter.startTag("tr");
        repWriter.writeTH(this.i18n.getString("kfl.f2nr.summary"), "row");
        repWriter.startTag("td");
        repWriter.writeLink(FAIL2NOTRUN, Integer.toString(this.sorter.getSet(KflSorter.Transitions.FAIL2NOTRUN).size()));
        repWriter.endTag("td");
        if (this.settings.isKflTestCasesEnabled()) {
            repWriter.startTag("td");
            repWriter.writeLink(TC_FAIL2NOTRUN, Integer.toString(this.sorter.getSet(KflSorter.Transitions.TC_FAIL2NOTRUN).size()));
            repWriter.endTag("td");
        }
        if (this.settings.isKflMissingEnabled()) {
            repWriter.startTag("tr");
            repWriter.writeTH(this.i18n.getString("kfl.f2m.summary"), "row");
            repWriter.startTag("td");
            repWriter.writeLink(FAIL2MISSING, Integer.toString(this.sorter.getSet(KflSorter.Transitions.FAIL2MISSING).size()));
            repWriter.endTag("td");
            if (this.settings.isKflTestCasesEnabled()) {
                repWriter.startTag("td");
                repWriter.writeLink(TC_FAIL2MISSING, Integer.toString(this.sorter.getSet(KflSorter.Transitions.TC_FAIL2MISSING).size()));
                repWriter.endTag("td");
            }
        }
        repWriter.startTag("tr");
        repWriter.writeTH(this.i18n.getString("kfl.new.summary"), "row");
        repWriter.startTag("td");
        repWriter.writeLink(NEWFAILURES, Integer.toString(this.sorter.getSet(KflSorter.Transitions.NEWFAILURES).size()));
        repWriter.endTag("td");
        if (this.settings.isKflTestCasesEnabled()) {
            repWriter.startTag("td");
            repWriter.writeLink(TC_NEWFAILURES, Integer.toString(this.sorter.getSet(KflSorter.Transitions.TC_NEWFAILURES).size()));
            repWriter.endTag("td");
        }
        repWriter.endTag("tr");
        if (this.settings.isKflF2fEnabled()) {
            repWriter.startTag("tr");
            repWriter.writeTH(this.i18n.getString("kfl.f2f.summary"), "row");
            repWriter.startTag("td");
            repWriter.writeLink(FAIL2FAIL, Integer.toString(this.sorter.getSet(KflSorter.Transitions.FAIL2FAIL).size()));
            repWriter.endTag("td");
            if (this.settings.isKflTestCasesEnabled()) {
                repWriter.startTag("td");
                repWriter.write(this.i18n.getString("kfl.f2f.notc"));
                repWriter.endTag("td");
            }
        }
        repWriter.endTag("table");
    }

    @Override
    void writeExtraFiles() throws IOException {
        if (this.kfl == null || this.sorter == null) {
            return;
        }
        this.writeSet(FAIL2MISSING, "kfl.f2m", this.sorter.getSet(KflSorter.Transitions.FAIL2MISSING));
        this.writeSet(FAIL2PASS, "kfl.f2p", this.sorter.getSet(KflSorter.Transitions.FAIL2PASS));
        this.writeSet(FAIL2ERROR, "kfl.f2e", this.sorter.getSet(KflSorter.Transitions.FAIL2ERROR));
        this.writeSet(FAIL2NOTRUN, "kfl.f2nr", this.sorter.getSet(KflSorter.Transitions.FAIL2NOTRUN));
        this.writeSet(FAIL2FAIL, "kfl.f2f", this.sorter.getSet(KflSorter.Transitions.FAIL2FAIL));
        this.writeSet(NEWFAILURES, "kfl.new", this.sorter.getSet(KflSorter.Transitions.NEWFAILURES));
        this.writeSet(OTHER_ERRORS, "kfl.errors", this.sorter.getSet(KflSorter.Transitions.OTHER_ERRORS));
        if (this.settings.isKflTestCasesEnabled()) {
            this.writeSet(TC_FAIL2MISSING, "kfl.tc_f2m", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2MISSING));
            this.writeSet(TC_FAIL2PASS, "kfl.tc_f2p", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2PASS));
            this.writeSet(TC_FAIL2ERROR, "kfl.tc_f2e", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2ERROR));
            this.writeSet(TC_FAIL2NOTRUN, "kfl.tc_f2nr", this.sorter.getSet(KflSorter.Transitions.TC_FAIL2NOTRUN));
            this.writeSet(TC_NEWFAILURES, "kfl.tc_new", this.sorter.getSet(KflSorter.Transitions.TC_NEWFAILURES));
        }
    }

    void writeSet(String file, String prefix, SortedSet<KflSorter.TestDiff> tests) throws IOException {
        ReportWriter out = new ReportWriter(this.openWriter(file), this.i18n.getString(prefix + ".title"), this.i18n);
        out.write(this.i18n.getString(prefix + ".notes"));
        if (tests == null || tests.isEmpty()) {
            out.write(this.i18n.getString("kfl.noItemsInSet"));
            out.newLine();
            out.close();
            return;
        }
        out.startTag("table");
        out.writeAttr("border", "1");
        out.startTag("tr");
        out.startTag("th");
        out.write(this.i18n.getString("kfl.table.bugs.txt"));
        out.endTag("th");
        out.startTag("th");
        out.write(this.i18n.getString("kfl.table.URL.txt"));
        out.endTag("th");
        out.endTag("tr");
        for (KflSorter.TestDiff diff : tests) {
            TestResult tr = diff.getTestResult();
            out.startTag("tr");
            out.startTag("td");
            this.writeBugs(diff, out);
            out.newLine();
            out.endTag("td");
            out.startTag("td");
            if (tr != null && tr.isReloadable()) {
                String eWRPath = tr.getWorkRelativePath();
                File eFile = new File(this.workDirRoot, eWRPath.replace('/', File.separatorChar));
                out.writeLink(eFile, diff.getName());
            } else {
                out.write(diff.getName());
            }
            out.endTag("td");
            out.endTag("tr");
        }
        out.endTag("table");
        out.close();
    }

    void writeBugs(KflSorter.TestDiff diff, ReportWriter writer) throws IOException {
        KnownFailuresList.Entry[] e = null;
        if (diff.getTestCase() == null) {
            e = this.kfl.find(diff.getTestName());
        } else {
            KnownFailuresList.Entry ee = this.kfl.find(diff.getTestName(), diff.getTestCase());
            if (ee != null) {
                e = new KnownFailuresList.Entry[]{ee};
            }
        }
        if (e == null || e.length == 0) {
            if (diff.getKflEntry() != null) {
                e = new KnownFailuresList.Entry[]{diff.getKflEntry()};
            } else {
                return;
            }
        }
        String urlPrefix = Preferences.access().getPreference("exec.report.bugurl", null);
        HashSet<String> hs = new HashSet<String>();
        for (KnownFailuresList.Entry anE : e) {
            String[] bugs = anE.getBugIdStrings();
            if (bugs == null || bugs.length == 0) {
                return;
            }
            for (int j = 0; j < bugs.length; ++j) {
                if (bugs[j].equals("0000000") || bugs[j].equals("0") || hs.contains(bugs[j])) continue;
                hs.add(bugs[j]);
                if (urlPrefix != null && !urlPrefix.isEmpty()) {
                    writer.writeLink(urlPrefix + bugs[j], bugs[j]);
                    writer.newLine();
                } else {
                    writer.write(bugs[j]);
                    writer.newLine();
                }
                if (bugs.length == j + 1) continue;
                writer.write(",");
            }
        }
        writer.newLine();
    }

    Writer openWriter(String file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.reportDir, file)), StandardCharsets.UTF_8));
    }
}

