/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProviderConfigurationEntry
implements Serializable {
    private String providerClassName = null;
    private Map<String, String> properties = null;
    private String messageLayer = null;
    private String applicationContextId = null;
    private String registrationDescription = null;

    public ProviderConfigurationEntry(Node providerConfigEntryNode) throws Exception {
        if (!providerConfigEntryNode.getNodeName().equals("provider-config-entry")) {
            throw new Exception("Unexpected tag :" + providerConfigEntryNode.getNodeName());
        }
        NodeList nodes = providerConfigEntryNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("#text")) continue;
            if (nodeName.equals("provider-class")) {
                this.providerClassName = this.getText(childNode);
                continue;
            }
            if (nodeName.equals("properties")) {
                this.properties = ProviderConfigurationEntry.loadProperties(childNode);
                continue;
            }
            if (nodeName.equals("message-layer")) {
                this.messageLayer = this.getText(childNode);
                continue;
            }
            if (nodeName.equals("app-context-id")) {
                this.applicationContextId = this.getText(childNode);
                continue;
            }
            if (!nodeName.equals("reg-description")) continue;
            this.registrationDescription = this.getText(childNode);
        }
    }

    private static Map<String, String> loadProperties(Node node) {
        Node topLevelChildNode = null;
        String key = null;
        String value = null;
        NamedNodeMap namedNodeMap = null;
        Properties nodeProperties = new Properties();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            topLevelChildNode = nodes.item(i);
            String topLevelNodeName = topLevelChildNode.getNodeName();
            if (topLevelNodeName.equals("#text") || !topLevelNodeName.equals("entry")) continue;
            namedNodeMap = topLevelChildNode.getAttributes();
            Node tempKeyNode = namedNodeMap.getNamedItem("key");
            key = tempKeyNode.getNodeValue();
            value = topLevelChildNode.getFirstChild().getNodeValue();
            nodeProperties.put(key, value);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        nodeProperties.stringPropertyNames().forEach(tmpkey -> map.put((String)tmpkey, nodeProperties.getProperty((String)tmpkey)));
        return map;
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    public String getMessageLayer() {
        return this.messageLayer;
    }

    public String getApplicationContextId() {
        return this.applicationContextId;
    }

    public String getRegistrationDescription() {
        return this.registrationDescription;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getText(Node textNode) {
        String result = "";
        NodeList nodes = textNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3) continue;
            result = node.getNodeValue();
            break;
        }
        if (result != null) {
            result = result.trim();
        }
        return result;
    }
}

