/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsongeneratorfactorytests;

import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonGeneratorFactoryTest1() {
        boolean pass = true;
        JsonGenerator generator1 = null;
        JsonGenerator generator2 = null;
        try {
            LOGGER.info("Create JsonGeneratorFactory with Map<String, ?> with PRETTY_PRINTING config");
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory((Map)JSONP_Util.getPrettyPrintingConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = generatorFactory.getConfigInUse();
            String[] props = new String[]{"jakarta.json.stream.JsonGenerator.prettyPrinting"};
            if (!JSONP_Util.doConfigCheck((Map)config, (int)1, (String[])props)) {
                pass = false;
            }
            LOGGER.info("--------------------------------------------------------");
            LOGGER.info("TEST CASE [JsonGeneratorFactory.createGenerator(Writer)]");
            LOGGER.info("--------------------------------------------------------");
            LOGGER.info("Create 1st JsonGenerator using JsonGeneratorFactory");
            StringWriter sWriter1 = new StringWriter();
            generator1 = generatorFactory.createGenerator((Writer)sWriter1);
            if (generator1 == null) {
                LOGGER.warning("GeneratorFactory failed to create generator1");
                pass = false;
            } else {
                generator1.writeStartObject().writeEnd();
                generator1.close();
            }
            LOGGER.info("sWriter1=" + sWriter1.toString());
            String expString = "{}";
            String actString = JSONP_Util.removeWhitespace((String)sWriter1.toString());
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
            LOGGER.info("Create 2nd JsonGenerator using JsonGeneratorFactory");
            StringWriter sWriter2 = new StringWriter();
            generator2 = generatorFactory.createGenerator((Writer)sWriter2);
            if (generator2 == null) {
                LOGGER.warning("GeneratorFactory failed to create generator2");
                pass = false;
            } else {
                generator2.writeStartArray().writeEnd();
                generator2.close();
            }
            LOGGER.info("sWriter2=" + sWriter2.toString());
            expString = "[]";
            actString = JSONP_Util.removeWhitespace((String)sWriter2.toString());
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorFactoryTest1 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonGeneratorFactoryTest1 Failed");
    }

    @Test
    public void jsonGeneratorFactoryTest2() {
        boolean pass = true;
        JsonGenerator generator1 = null;
        JsonGenerator generator2 = null;
        try {
            LOGGER.info("Create JsonGeneratorFactory with Map<String, ?> with PRETTY_PRINTING config");
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory((Map)JSONP_Util.getPrettyPrintingConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = generatorFactory.getConfigInUse();
            String[] props = new String[]{"jakarta.json.stream.JsonGenerator.prettyPrinting"};
            if (!JSONP_Util.doConfigCheck((Map)config, (int)1, (String[])props)) {
                pass = false;
            }
            LOGGER.info("-----------------------------------------------------------------------");
            LOGGER.info("TEST CASE [JsonGeneratorFactory.createGenerator(OutputStream, Charset)]");
            LOGGER.info("-----------------------------------------------------------------------");
            LOGGER.info("Create 1st JsonGenerator using JsonGeneratorFactory with UTF-8 encoding");
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            generator1 = generatorFactory.createGenerator((OutputStream)baos1, JSONP_Util.UTF_8);
            if (generator1 == null) {
                LOGGER.warning("GeneratorFactory failed to create generator1");
                pass = false;
            } else {
                generator1.writeStartObject().writeEnd();
                generator1.close();
            }
            LOGGER.info("baos1=" + baos1.toString("UTF-8"));
            String expString = "{}";
            String actString = JSONP_Util.removeWhitespace((String)baos1.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
            LOGGER.info("Create 2nd JsonGenerator using JsonGeneratorFactory with UTF-16BE encoding");
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            generator2 = generatorFactory.createGenerator((OutputStream)baos2, JSONP_Util.UTF_16BE);
            if (generator2 == null) {
                LOGGER.warning("GeneratorFactory failed to create generator2");
                pass = false;
            } else {
                generator2.writeStartArray().writeEnd();
                generator2.close();
            }
            LOGGER.info("baos2=" + baos2.toString("UTF-16BE"));
            expString = "[]";
            actString = JSONP_Util.removeWhitespace((String)baos2.toString("UTF-16BE"));
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorFactoryTest2 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonGeneratorFactoryTest2 Failed");
    }

    @Test
    public void jsonGeneratorFactoryTest3() {
        boolean pass = true;
        JsonGenerator generator1 = null;
        JsonGenerator generator2 = null;
        try {
            LOGGER.info("Create JsonGeneratorFactory with Map<String, ?> with PRETTY_PRINTING config");
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory((Map)JSONP_Util.getPrettyPrintingConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = generatorFactory.getConfigInUse();
            String[] props = new String[]{"jakarta.json.stream.JsonGenerator.prettyPrinting"};
            if (!JSONP_Util.doConfigCheck((Map)config, (int)1, (String[])props)) {
                pass = false;
            }
            LOGGER.info("-----------------------------------------------------------------");
            LOGGER.info("TEST CASE [JsonGeneratorFactory.createGenerator(OutputStream os)]");
            LOGGER.info("-----------------------------------------------------------------");
            LOGGER.info("Create 1st JsonGenerator using JsonGeneratorFactory");
            ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
            generator1 = generatorFactory.createGenerator((OutputStream)baos1);
            if (generator1 == null) {
                LOGGER.warning("GeneratorFactory failed to create generator1");
                pass = false;
            } else {
                generator1.writeStartObject().writeEnd();
                generator1.close();
            }
            LOGGER.info("baos1=" + baos1.toString("UTF-8"));
            String expString = "{}";
            String actString = JSONP_Util.removeWhitespace((String)baos1.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
            LOGGER.info("Create 2nd JsonGenerator using JsonGeneratorFactory");
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            generator2 = generatorFactory.createGenerator((OutputStream)baos2);
            if (generator2 == null) {
                LOGGER.warning("GeneratorFactory failed to create generator2");
                pass = false;
            } else {
                generator2.writeStartArray().writeEnd();
                generator2.close();
            }
            LOGGER.info("baos2=" + baos2.toString("UTF-8"));
            expString = "[]";
            actString = JSONP_Util.removeWhitespace((String)baos2.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText((String)expString, (String)actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorFactoryTest3 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonGeneratorFactoryTest3 Failed");
    }

    @Test
    public void jsonGeneratorFactoryTest4() {
        boolean pass = true;
        try {
            LOGGER.info("----------------------------------------------");
            LOGGER.info("Test scenario1: no supported provider property");
            LOGGER.info("----------------------------------------------");
            LOGGER.info("Create JsonGeneratorFactory with Map<String, ?> with EMPTY config");
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory((Map)JSONP_Util.getEmptyConfig());
            Map config = generatorFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("-------------------------------------------");
            LOGGER.info("Test scenario2: supported provider property");
            LOGGER.info("-------------------------------------------");
            LOGGER.info("Create JsonGeneratorFactory with Map<String, ?> with PRETTY_PRINTING config");
            generatorFactory = Json.createGeneratorFactory((Map)JSONP_Util.getPrettyPrintingConfig());
            config = generatorFactory.getConfigInUse();
            String[] props = new String[]{"jakarta.json.stream.JsonGenerator.prettyPrinting"};
            if (!JSONP_Util.doConfigCheck((Map)config, (int)1, (String[])props)) {
                pass = false;
            }
            LOGGER.info("-------------------------------------------------------------");
            LOGGER.info("Test scenario3: supported and non supported provider property");
            LOGGER.info("-------------------------------------------------------------");
            LOGGER.info("Create JsonGeneratorFactory with Map<String, ?> with all config");
            generatorFactory = Json.createGeneratorFactory((Map)JSONP_Util.getAllConfig());
            config = generatorFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)1, (String[])props)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGeneratorFactoryTest4 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonGeneratorFactoryTest4 Failed");
    }
}

