/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BinaryTestFinder
extends TestFinder {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(BinaryTestFinder.class);
    private File jtdFile;
    private ZipFile zipFile;
    private ZipEntry stringsEntry;
    private ZipEntry testsEntry;
    private ZipEntry treeEntry;
    private boolean zipFileRead;
    private StringTable stringTable;
    private TestTable testTable;
    private TestTree testTree;

    public BinaryTestFinder() {
    }

    @Deprecated
    public BinaryTestFinder(File jtdFile) throws TestFinder.Fault {
        this.jtdFile = jtdFile;
        this.openBinaryFile(true);
    }

    @Deprecated
    public BinaryTestFinder(File testSuiteRoot, File jtdFile) throws TestFinder.Fault {
        this.init(testSuiteRoot, jtdFile);
    }

    private static int readInt(DataInputStream in) throws IOException {
        int b;
        int n = 0;
        while ((b = in.readUnsignedByte()) >= 128) {
            n = n << 7 | b & 0x7F;
        }
        n = n << 7 | b;
        return n;
    }

    @Override
    public void init(String[] args, File testSuiteRoot, TestEnvironment env) throws TestFinder.Fault {
        super.init(args, testSuiteRoot, env);
        this.openBinaryFile(true);
    }

    @Deprecated
    public void init(File testSuiteRoot, File jtdFile) throws TestFinder.Fault {
        super.init(null, testSuiteRoot, null);
        this.jtdFile = jtdFile;
        this.openBinaryFile(true);
    }

    @Override
    protected int decodeArg(String[] args, int i) throws TestFinder.Fault {
        if (args[i].equalsIgnoreCase("-binary") || args[i].equalsIgnoreCase("-jtd")) {
            String e = args[i + 1];
            this.jtdFile = new File(e);
            return 2;
        }
        if (i == args.length - 1 && !args[i].startsWith("-")) {
            this.jtdFile = new File(args[i]);
            return 1;
        }
        return super.decodeArg(args, i);
    }

    @Override
    public long lastModified(File f) {
        return 1L;
    }

    @Override
    public boolean isFolder(File path) {
        TestTree.Node node;
        if (this.zipFile != null || this.zipFileRead) {
            this.readBinaryFile();
        }
        File rootDir = this.getRootDir();
        String relPath = this.getRelativePath(rootDir, path);
        TestTree.Node node2 = node = this.testTree == null ? null : this.testTree.getNode(relPath);
        if (path.getPath().endsWith(".html") || path.getPath().endsWith(".java") || path.getPath().endsWith(".xml")) {
            return false;
        }
        return node != null;
    }

    @Override
    protected void scan(File file) {
        if (this.zipFile != null || this.zipFileRead) {
            this.readBinaryFile();
        }
        try {
            TestTree.Node node;
            File rootDir = this.getRootDir();
            String relPath = this.getRelativePath(rootDir, file);
            TestTree.Node node2 = node = this.testTree == null ? null : this.testTree.getNode(relPath);
            if (node == null) {
                this.error(i18n, "bin.cantFindPath", (Object)file.getPath());
                return;
            }
            TestTree.Node[] children = node.children;
            if (children != null) {
                for (TestTree.Node child : children) {
                    File f = relPath.isEmpty() ? new File(child.name) : new File(relPath, child.name);
                    this.foundFile(f);
                }
            }
            if (node.testIndexes != null) {
                File testFile = new File(relPath);
                for (int i = 0; i < node.testIndexes.length; ++i) {
                    TestDescription td = node.getTest(i, rootDir, testFile, this.testTable);
                    this.foundTestDescription(td);
                }
            }
        }
        catch (IOException e) {
            this.error(i18n, "bin.internalIOError", file.getPath(), e);
        }
    }

    private String getRelativePath(File rootDir, File file) {
        if (file.isAbsolute()) {
            String rootDirPath = rootDir.getPath();
            String filePath = file.getPath();
            if (filePath.startsWith(rootDirPath)) {
                return filePath.equals(rootDirPath) ? "" : filePath.substring(rootDirPath.length() + 1);
            }
            throw new IllegalArgumentException();
        }
        return file.getPath();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openBinaryFile(boolean closeIfSuccess) throws TestFinder.Fault {
        block14: {
            try {
                this.zipFileRead = false;
                if (this.jtdFile == null) {
                    throw new TestFinder.Fault(i18n, "bin.noFile");
                }
                File root = this.getRoot();
                File f = this.jtdFile.isAbsolute() || root == null ? this.jtdFile : new File(root, this.jtdFile.getPath());
                this.zipFile = new ZipFile(f);
                this.stringsEntry = this.zipFile.getEntry("strings");
                this.testsEntry = this.zipFile.getEntry("tests");
                this.treeEntry = this.zipFile.getEntry("tree");
                if (this.stringsEntry == null) throw new TestFinder.Fault(i18n, "bin.badBinFile", (Object)this.zipFile.getName());
                if (this.testsEntry == null) throw new TestFinder.Fault(i18n, "bin.badBinFile", (Object)this.zipFile.getName());
                if (this.treeEntry == null) {
                    throw new TestFinder.Fault(i18n, "bin.badBinFile", (Object)this.zipFile.getName());
                }
                this.zipFileRead = true;
                if (!closeIfSuccess) {
                    if (this.zipFileRead) return;
                }
                if (this.zipFile == null) break block14;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new TestFinder.Fault(i18n, "bin.cantFindFile", (Object)this.jtdFile.getPath());
                    catch (IOException e2) {
                        throw new TestFinder.Fault(i18n, "bin.ioError", this.jtdFile.getPath(), e2);
                    }
                }
                catch (Throwable throwable) {
                    if (!closeIfSuccess) {
                        if (this.zipFileRead) throw throwable;
                    }
                    if (this.zipFile != null) {
                        try {
                            this.zipFile.close();
                        }
                        catch (IOException e3) {
                            throw new TestFinder.Fault(i18n, "bin.ioError", this.jtdFile.getPath(), e3);
                        }
                    }
                    this.stringsEntry = null;
                    this.testsEntry = null;
                    this.treeEntry = null;
                    this.zipFile = null;
                    throw throwable;
                }
            }
            try {
                this.zipFile.close();
            }
            catch (IOException e) {
                throw new TestFinder.Fault(i18n, "bin.ioError", this.jtdFile.getPath(), e);
            }
        }
        this.stringsEntry = null;
        this.testsEntry = null;
        this.treeEntry = null;
        this.zipFile = null;
    }

    /*
     * Loose catch block
     */
    public synchronized void readBinaryFile() {
        block14: {
            if (this.zipFile == null && this.zipFileRead) {
                try {
                    this.openBinaryFile(false);
                }
                catch (TestFinder.Fault ex) {
                    this.localizedError(ex.getLocalizedMessage());
                    this.zipFile = null;
                }
            }
            if (this.zipFile == null) {
                throw new IllegalStateException();
            }
            this.stringTable = StringTable.read(this.zipFile, this.stringsEntry);
            this.testTable = TestTable.read(this.zipFile, this.testsEntry, this.stringTable);
            this.testTree = TestTree.read(this.zipFile, this.treeEntry);
            this.zipFileRead = false;
            try {
                this.zipFile.close();
            }
            catch (IOException e) {
                this.error(i18n, "bin.ioError", this.jtdFile.getPath(), e);
            }
            this.stringsEntry = null;
            this.testsEntry = null;
            this.treeEntry = null;
            this.zipFile = null;
            break block14;
            catch (IOException e) {
                try {
                    this.error(i18n, "bin.ioError", this.jtdFile.getPath(), e);
                }
                catch (Throwable throwable) {
                    try {
                        this.zipFile.close();
                    }
                    catch (IOException e2) {
                        this.error(i18n, "bin.ioError", this.jtdFile.getPath(), e2);
                    }
                    this.stringsEntry = null;
                    this.testsEntry = null;
                    this.treeEntry = null;
                    this.zipFile = null;
                    throw throwable;
                }
                try {
                    this.zipFile.close();
                }
                catch (IOException e3) {
                    this.error(i18n, "bin.ioError", this.jtdFile.getPath(), e3);
                }
                this.stringsEntry = null;
                this.testsEntry = null;
                this.treeEntry = null;
                this.zipFile = null;
            }
        }
    }

    public StringTable getStringTable() {
        return this.stringTable;
    }

    public TestTable getTestTable() {
        return this.testTable;
    }

    public TestTree getTestTree() {
        return this.testTree;
    }

    @Override
    public Optional<Integer> totalNumberOfTestsInTheSuite() {
        return Optional.of(this.testTree.testsTotal);
    }

    public static class TestTree {
        private Node root;
        private final int testsTotal;

        TestTree(Node root, int testsTotal) {
            this.root = root;
            this.testsTotal = testsTotal;
        }

        static TestTree read(ZipFile zf, ZipEntry ze) throws IOException {
            DataInputStream in = new DataInputStream(new BufferedInputStream(zf.getInputStream(ze)));
            AtomicInteger testCounter = new AtomicInteger();
            Node root = new Node(in, testCounter);
            return new TestTree(root, testCounter.get());
        }

        public Node getNode(String path) {
            return path.isEmpty() ? this.root : this.root.getNode(path);
        }

        public static class Node {
            private String name;
            private int[] testIndexes;
            private Node[] children;

            Node(DataInputStream in, AtomicInteger testCounter) throws IOException {
                int childCount;
                this.name = in.readUTF();
                int testCount = BinaryTestFinder.readInt(in);
                testCounter.addAndGet(testCount);
                if (testCount > 0) {
                    this.testIndexes = new int[testCount];
                    for (int i = 0; i < this.testIndexes.length; ++i) {
                        this.testIndexes[i] = BinaryTestFinder.readInt(in);
                    }
                }
                if ((childCount = BinaryTestFinder.readInt(in)) > 0) {
                    this.children = new Node[childCount];
                    for (int i = 0; i < this.children.length; ++i) {
                        this.children[i] = new Node(in, testCounter);
                    }
                }
            }

            public Node getNode(String path) {
                int sep = path.indexOf(File.separatorChar);
                String head = sep == -1 ? path : path.substring(0, sep);
                for (Node child : this.children) {
                    if (!child.name.equals(head)) continue;
                    return sep == -1 ? child : child.getNode(path.substring(sep + 1));
                }
                return null;
            }

            public String getName() {
                return this.name;
            }

            public int[] getTestIndexes() {
                return this.testIndexes;
            }

            public Node[] getChildren() {
                return this.children;
            }

            public TestDescription getTest(int index, File root, File path, TestTable testTable) throws IOException {
                if (this.testIndexes == null || index > this.testIndexes.length) {
                    throw new IllegalArgumentException();
                }
                return testTable.get(root, path, this.testIndexes[index]);
            }
        }
    }

    public static class TestTable {
        private ByteArrayInputStream bais;
        private StringTable stringTable;

        TestTable(byte[] data, StringTable stringTable) {
            this.bais = new ByteArrayInputStream(data);
            this.stringTable = stringTable;
        }

        static TestTable read(ZipFile zf, ZipEntry ze, StringTable stringTable) throws IOException {
            byte[] bytes = new byte[(int)ze.getSize()];
            InputStream in = zf.getInputStream(ze);
            for (int total = 0; total < bytes.length; total += in.read(bytes, total, bytes.length - total)) {
            }
            return new TestTable(bytes, stringTable);
        }

        TestDescription get(File root, File file, int index) throws IOException {
            this.bais.reset();
            this.bais.skip(index);
            HashMap<String, String> m = new HashMap<String, String>();
            DataInputStream in = new DataInputStream(this.bais);
            int n = BinaryTestFinder.readInt(in);
            for (int i = 0; i < n; ++i) {
                String key = this.stringTable.readRef(in);
                String value = this.stringTable.readRef(in);
                m.put(key, value);
            }
            return new TestDescription(root, file, m);
        }
    }

    static class StringTable {
        private String[] strings;

        StringTable(DataInputStream in) throws IOException {
            int count = BinaryTestFinder.readInt(in);
            this.strings = new String[count];
            for (int i = 0; i < count; ++i) {
                this.strings[i] = in.readUTF();
            }
        }

        static StringTable read(ZipFile zf, ZipEntry ze) throws IOException {
            DataInputStream in = new DataInputStream(new BufferedInputStream(zf.getInputStream(ze)));
            return new StringTable(in);
        }

        String readRef(DataInputStream in) throws IOException {
            int index = BinaryTestFinder.readInt(in);
            if (index == 0) {
                return in.readUTF();
            }
            return this.strings[index];
        }

        String get(int i) {
            return this.strings[i];
        }
    }
}

