/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import com.sun.javatest.tool.jthelp.HelpBroker;
import com.sun.javatest.util.DynamicArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public abstract class Tool
extends JPanel {
    private static int toolIndex;
    protected final UIFactory uif;
    private ToolManager manager;
    private String title;
    private String shortTitle;
    private String helpID;
    private long creationTime;
    private List<WeakReference<ToolDialog>> toolDialogs;
    private DeskView deskView;
    private Observer[] observers = new Observer[0];

    protected Tool(ToolManager m, String uiKey) {
        super(new BorderLayout());
        this.setName(uiKey + ":" + toolIndex++);
        this.setFocusable(false);
        this.manager = m;
        this.uif = new UIFactory(this, m.getDesktop().getHelpBroker());
        this.uif.setAccessibleName(this, uiKey);
        this.uif.setToolTip(this, uiKey);
        this.creationTime = System.currentTimeMillis();
    }

    protected Tool(ToolManager m, String uiKey, String helpID) {
        this(m, uiKey);
        ContextHelpManager.setHelpIDString(this, helpID);
    }

    public synchronized void addObserver(Observer o) {
        this.observers = DynamicArray.append(this.observers, o);
    }

    public synchronized void removeObserver(Observer o) {
        this.observers = DynamicArray.remove(this.observers, o);
    }

    public abstract JMenuBar getMenuBar();

    protected void setI18NTitle(String key) {
        this.setLocalizedTitle(this.uif.getI18NString(key));
    }

    protected void setI18NTitle(String key, Object arg) {
        this.setLocalizedTitle(this.uif.getI18NString(key, arg));
    }

    protected void setI18NTitle(String key, Object ... args) {
        this.setLocalizedTitle(this.uif.getI18NString(key, args));
    }

    private synchronized void setLocalizedTitle(String newTitle) {
        if (this.title == null ? newTitle == null : this.title.equals(newTitle)) {
            return;
        }
        this.title = newTitle;
        for (Observer observer : this.observers) {
            observer.titleChanged(this, this.title);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortTitle() {
        if (this.shortTitle != null) {
            return this.shortTitle;
        }
        if (this.title != null) {
            return this.title;
        }
        return this.getName();
    }

    public void setShortTitle(String newShortTitle) {
        if (this.shortTitle == null ? newShortTitle == null : this.shortTitle.equals(newShortTitle)) {
            return;
        }
        this.shortTitle = newShortTitle;
        for (Observer observer : this.observers) {
            observer.shortTitleChanged(this, this.shortTitle);
        }
    }

    public TestSuite[] getLoadedTestSuites() {
        return null;
    }

    public WorkDirectory[] getLoadedWorkDirectories() {
        return null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void dispose() {
        this.removeAll();
        this.uif.dispose();
        for (int i = this.observers.length - 1; i >= 0; --i) {
            this.observers[i].toolDisposed(this);
        }
        this.observers = new Observer[0];
    }

    public ToolManager getManager() {
        return this.manager;
    }

    public Desktop getDesktop() {
        return this.manager.getDesktop();
    }

    public HelpBroker getHelpBroker() {
        return this.manager.getDesktop().getHelpBroker();
    }

    protected abstract void save(Map<String, String> var1);

    protected abstract void restore(Map<String, String> var1);

    protected String[] getCloseAlerts() {
        return null;
    }

    protected void setHelp(String helpID) {
        this.setHelp(this, helpID);
    }

    protected void setHelp(Component comp, String helpID) {
        HelpBroker b = this.getHelpBroker();
        if (b != null) {
            if (comp instanceof JDialog) {
                JDialog d = (JDialog)comp;
                Desktop.addHelpDebugListener(d);
                b.enableHelpKey(d.getRootPane(), helpID);
                ContextHelpManager.setHelpIDString(d.getRootPane(), helpID);
            } else {
                b.enableHelpKey(comp, helpID);
                ContextHelpManager.setHelpIDString(comp, helpID);
            }
        }
    }

    protected void setHelpOnButton(Component comp, String helpID) {
        HelpBroker b = this.getHelpBroker();
        if (b != null) {
            b.enableHelpKey(comp, helpID);
        }
    }

    public ToolDialog[] getToolDialogs() {
        if (this.toolDialogs == null) {
            return new ToolDialog[0];
        }
        ArrayList<ToolDialog> l = new ArrayList<ToolDialog>();
        Iterator<WeakReference<ToolDialog>> iter = this.toolDialogs.iterator();
        while (iter.hasNext()) {
            WeakReference<ToolDialog> r = iter.next();
            ToolDialog td = (ToolDialog)r.get();
            if (td == null) {
                iter.remove();
                continue;
            }
            l.add(td);
        }
        return l.toArray(new ToolDialog[l.size()]);
    }

    void addToolDialog(ToolDialog td) {
        if (td == null) {
            throw new NullPointerException();
        }
        if (this.toolDialogs == null) {
            this.toolDialogs = new ArrayList<WeakReference<ToolDialog>>();
        }
        this.toolDialogs.add(new WeakReference<ToolDialog>(td));
    }

    DeskView getDeskView() {
        return this.deskView;
    }

    void setDeskView(DeskView view) {
        this.deskView = view;
    }

    public static interface Observer {
        public void titleChanged(Tool var1, String var2);

        public void shortTitleChanged(Tool var1, String var2);

        public void toolDisposed(Tool var1);
    }
}

