/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.CommentStream;
import com.sun.javatest.finder.JavaCommentStream;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class TagTestFinder
extends TestFinder {
    private static final String[] excludeNames = new String[]{"SCCS", "deleted_files", ".svn", ".git", ".hg"};
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TagTestFinder.class);
    private File currFile;
    private Map<String, String> excludeList = new HashMap<String, String>();
    private Map<String, Class<? extends CommentStream>> extensionTable = new HashMap<String, Class<? extends CommentStream>>();
    private boolean fastScan = false;
    private String initialTag = "test";

    public TagTestFinder() {
        this.exclude(excludeNames);
        this.addExtension(".java", JavaCommentStream.class);
    }

    @Override
    protected int decodeArg(String[] args, int i) throws TestFinder.Fault {
        if ("-fast".equalsIgnoreCase(args[i])) {
            this.fastScan = true;
            return 1;
        }
        return super.decodeArg(args, i);
    }

    @Override
    public void scan(File file) {
        this.currFile = file;
        if (file.isDirectory()) {
            this.scanDirectory(file);
        } else {
            this.scanFile(file);
        }
    }

    protected File getCurrentFile() {
        return this.currFile;
    }

    public void exclude(String name) {
        this.excludeList.put(name, name);
    }

    public void exclude(String ... names) {
        for (String name : names) {
            this.excludeList.put(name, name);
        }
    }

    public void unexclude(String name) {
        this.excludeList.remove(name);
    }

    public boolean isExcluded(String s) {
        return this.excludeList.containsKey(s);
    }

    public void addExtension(String extn, Class<? extends CommentStream> commentStreamClass) {
        if (!extn.startsWith(".")) {
            throw new IllegalArgumentException("extension must begin with `.'");
        }
        if (!CommentStream.class.isAssignableFrom(commentStreamClass)) {
            throw new IllegalArgumentException("class must be a subtype of " + CommentStream.class.getName());
        }
        this.extensionTable.put(extn, commentStreamClass);
    }

    public Class<? extends CommentStream> getClassForExtension(String extn) {
        return this.extensionTable.get(extn);
    }

    public String getInitialTag() {
        return this.initialTag;
    }

    public void setInitialTag(String tag) {
        this.initialTag = tag;
    }

    private void scanDirectory(File dir) {
        String[] names = dir.list();
        if (names == null) {
            this.error(i18n, "tag.readError", (Object)dir.getAbsolutePath());
            return;
        }
        for (String name : names) {
            String extn;
            if (this.excludeList.containsKey(name)) continue;
            File file = new File(dir, name);
            if (file.isDirectory()) {
                this.foundFile(file);
                continue;
            }
            int dot = name.indexOf(46);
            if (dot == -1 || !this.extensionTable.containsKey(extn = name.substring(dot))) continue;
            this.foundFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanFile(File file) {
        int testDescNumber = 0;
        String name = file.getName();
        int dot = name.indexOf(46);
        if (dot == -1) {
            return;
        }
        String extn = name.substring(dot);
        Class<? extends CommentStream> csc = this.extensionTable.get(extn);
        if (csc == null) {
            this.error(i18n, "tag.noParser", file, extn);
            return;
        }
        CommentStream cs = null;
        try {
            cs = csc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.error(i18n, "tag.cantCreateClass", csc.getName(), extn);
            return;
        }
        catch (IllegalAccessException e) {
            this.error(i18n, "tag.cantAccessClass", csc.getName(), extn);
            return;
        }
        try {
            cs.init(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8)));
            if (this.fastScan) {
                cs.setFastScan(true);
            }
            String comment = cs.readComment();
            while (comment != null) {
                Map<String, String> tagValues = this.parseComment(comment, file);
                comment = cs.readComment();
                if (tagValues.isEmpty()) continue;
                if (tagValues.get("id") == null) {
                    if (comment != null || testDescNumber != 0) {
                        tagValues.put("id", "id" + Integer.valueOf(testDescNumber).toString());
                    }
                    ++testDescNumber;
                }
                tagValues.remove("test");
                this.foundTestDescription(tagValues, file, 0);
            }
        }
        catch (FileNotFoundException e) {
            this.error(i18n, "tag.cantFindFile", (Object)file);
        }
        catch (IOException e) {
            this.error(i18n, "tag.ioError", (Object)file);
        }
        finally {
            try {
                cs.close();
            }
            catch (IOException e) {}
        }
    }

    protected Map<String, String> parseComment(String comment, File currFile) {
        HashMap<String, String> tagValues = new HashMap<String, String>();
        int tagStart = 0;
        int tagEnd = 0;
        while ((tagStart = this.findTagStart(comment, tagEnd)) != -1) {
            int pos;
            tagEnd = this.findTagEnd(comment, tagStart);
            String tag = comment.substring(tagStart, tagEnd);
            for (pos = 0; pos < tag.length() && !Character.isWhitespace(tag.charAt(pos)); ++pos) {
            }
            String name = tag.substring(1, pos);
            while (pos < tag.length() && Character.isWhitespace(tag.charAt(pos))) {
                ++pos;
            }
            String value = tag.substring(pos);
            value = value.replace('\n', ' ').replace('\r', ' ').trim();
            if (tagValues.isEmpty() && this.initialTag != null && !name.equals(this.initialTag)) {
                return tagValues;
            }
            this.processEntry(tagValues, name, value);
        }
        return tagValues;
    }

    private int findTagStart(String s, int pos) {
        while ((pos = s.indexOf(64, pos)) != -1 && pos < s.length() - 1) {
            if (pos == 0 && !Character.isWhitespace(s.charAt(pos + 1)) || pos > 0 && !Character.isWhitespace(s.charAt(pos + 1)) && Character.isWhitespace(s.charAt(pos - 1))) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    private int findTagEnd(String s, int tagStart) {
        int end = this.findTagStart(s, tagStart + 1);
        if (end == -1) {
            return s.length();
        }
        return end;
    }
}

