/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.NoBannerLogger;

public class TSLogger
extends NoBannerLogger {
    private static String[] msg2Ignore = new String[]{"No local string for", "WARNING: no help for", "CESV: no help for"};
    private static List failedDirs;
    private long startTime;

    public void messageLogged(BuildEvent event) {
        String msg = event.getMessage();
        for (int i = 0; i < msg2Ignore.length; ++i) {
            if (!msg.startsWith(msg2Ignore[i])) continue;
            return;
        }
        super.messageLogged(event);
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        StringBuffer sb = null;
        if (error == null && failedDirs == null) {
            this.out.println(lSep + "BUILD SUCCESSFUL");
        } else if (error != null) {
            this.err.println(lSep + "BUILD FAILED" + lSep);
            if (3 <= this.msgOutputLevel || !(error instanceof BuildException)) {
                error.printStackTrace(this.err);
            } else if (error instanceof BuildException) {
                this.err.println(error.toString());
            } else {
                this.err.println(error.getMessage());
            }
        }
        if (failedDirs != null) {
            sb = new StringBuffer();
            int n = failedDirs.size();
            for (int i = 0; i < n; ++i) {
                sb.append(failedDirs.get(i).toString()).append('\n');
            }
            if (error != null) {
                this.err.println(lSep + "In addition, the following directories failed:");
            } else {
                this.err.println(lSep + "BUILD FAILED");
                this.err.println(lSep + "The following directories failed:");
            }
            this.err.println(sb.toString());
        }
        this.out.println(lSep + "Total time: " + TSLogger.formatTime((long)(System.currentTimeMillis() - this.startTime)));
        if (failedDirs != null) {
            throw new BuildException("ERROR: Some directories failed to build.  See list of failed directories above.");
        }
        if (error != null) {
            throw new BuildException(error);
        }
    }

    public static void addFailedDir(String s) {
        if (failedDirs == null) {
            failedDirs = new ArrayList();
        }
        if (!failedDirs.contains(s)) {
            failedDirs.add(s);
        }
    }
}

