/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

public class Status {
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int ERROR = 2;
    public static final int NOT_RUN = 3;
    public static final int NUM_STATES = 4;
    private final int type;
    private final String reason;
    public static final String EXIT_PREFIX = "STATUS:";
    private static String[] texts = new String[]{"Passed.", "Failed.", "Error.", "Not run."};
    public static final int[] exitCodes = new int[]{95, 97, 98, 99};

    public static Status passed(String reason) {
        return new Status(0, reason);
    }

    public static Status failed(String reason) {
        return new Status(1, reason);
    }

    public static Status error(String reason) {
        return new Status(2, reason);
    }

    public static Status notApplicable(String reason) {
        return new Status(1, "Not Applicable: " + reason);
    }

    static Status notRun(String reason) {
        return new Status(3, reason);
    }

    public boolean isPassed() {
        return this.type == 0;
    }

    public boolean isFailed() {
        return this.type == 1;
    }

    public boolean isError() {
        return this.type == 2;
    }

    public boolean isNotRun() {
        return this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public Status augment(String aux) {
        if (aux == null || aux.length() == 0) {
            return this;
        }
        return new Status(this.type, this.reason + " [" + aux + "]");
    }

    public Status augment(Status aux) {
        return aux == null ? this : this.augment(aux.reason);
    }

    public static Status parse(String s) {
        try {
            return new Status(s);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private Status(String s) {
        for (int t = 0; t < texts.length; ++t) {
            if (!s.startsWith(texts[t])) continue;
            int l = texts[t].length();
            String r = l < s.length() ? (s.charAt(l) == ' ' ? s.substring(l + 1) : s.substring(l)) : "";
            this.type = t;
            this.reason = r;
            return;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        if (this.reason == null || this.reason.length() == 0) {
            return texts[this.type];
        }
        return texts[this.type] + " " + this.reason;
    }

    public static String typeToString(int typeNum) {
        if (typeNum < 4) {
            return texts[typeNum];
        }
        return null;
    }

    public void exit() {
        if (System.err != null) {
            System.err.print(EXIT_PREFIX);
            System.err.print(texts[this.type]);
            System.err.println(this.reason);
            System.err.flush();
        }
        System.exit(exitCodes[this.type]);
    }

    public Status(int type, String reason) throws IllegalArgumentException {
        if (type < 0 || type >= 4) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
        for (int i = 0; i < reason.length(); ++i) {
            if (Status.isPrintable(reason.charAt(i))) continue;
            StringBuffer r = new StringBuffer(reason.length());
            for (int j = 0; j < reason.length(); ++j) {
                char c = reason.charAt(j);
                r.append(Status.isPrintable(c) ? c : (char)' ');
            }
            reason = r.toString();
            break;
        }
        this.type = type;
        this.reason = reason.trim();
    }

    private static boolean isPrintable(char c) {
        return ' ' <= c && c < '\u007f';
    }
}

