/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.ExcludeListFilter;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.Objects;

public class InitialUrlFilter
extends TestFilter {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ExcludeListFilter.class);
    private final String[] initUrls;
    private final File[] initFiles;
    private final String[] initStrings;

    public InitialUrlFilter(File ... initFiles) {
        this.initFiles = initFiles;
        this.initStrings = null;
        if (initFiles == null || initFiles.length == 0) {
            this.initUrls = null;
        } else {
            this.initUrls = new String[initFiles.length];
            for (int i = 0; i < initFiles.length; ++i) {
                if (initFiles[i].isAbsolute()) {
                    throw new IllegalArgumentException(initFiles[i].getPath());
                }
                this.initUrls[i] = initFiles[i].getPath().toLowerCase();
                if (File.separatorChar == '/') continue;
                this.initUrls[i] = this.initUrls[i].replace(File.separatorChar, '/');
            }
        }
    }

    public InitialUrlFilter(String ... initialUrls) {
        this.initStrings = initialUrls;
        this.initFiles = null;
        if (initialUrls == null || initialUrls.length == 0) {
            this.initUrls = null;
        } else {
            this.initUrls = new String[initialUrls.length];
            for (int i = 0; i < initialUrls.length; ++i) {
                this.initUrls[i] = initialUrls[i].toLowerCase();
            }
        }
    }

    public static boolean isInitialUrlMatch(String toCheck, String compareTo) {
        Objects.requireNonNull(compareTo, "Known initial URL to compare should not be `null`");
        if (compareTo.isEmpty()) {
            throw new IllegalArgumentException("Known initial URL to compare should not be empty");
        }
        if (toCheck.equals(compareTo)) {
            return true;
        }
        return toCheck.startsWith(compareTo) && (InitialUrlFilter.isDelimiter(compareTo.charAt(compareTo.length() - 1)) || InitialUrlFilter.isDelimiter(toCheck.charAt(compareTo.length())));
    }

    private static boolean isDelimiter(char c) {
        return c == '/' || c == '#';
    }

    @Override
    public boolean accepts(TestDescription td) {
        if (this.initUrls == null) {
            return true;
        }
        String testUrl = td.getRootRelativeURL().toLowerCase();
        for (String urlI : this.initUrls) {
            if (!InitialUrlFilter.isInitialUrlMatch(testUrl, urlI)) continue;
            return true;
        }
        return false;
    }

    public File[] getInitFiles() {
        return this.initFiles;
    }

    public String[] getInitStrings() {
        return this.initStrings;
    }

    @Override
    public String getName() {
        return i18n.getString("iurlFilter.name");
    }

    @Override
    public String getDescription() {
        return i18n.getString("iurlFilter.description");
    }

    @Override
    public String getReason() {
        return i18n.getString("iurlFilter.reason");
    }
}

