/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    public Response toResponse(WebApplicationException exception) {
        Response response = exception.getResponse();
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (status != null) {
            sb.append("|status=").append(status.name());
        }
        for (Throwable t = exception.getCause(); t != null; t = t.getCause()) {
            sb.append("|msg=").append(t.getMessage());
            sb.append("|ex=").append(t.getClass().getName());
        }
        return Response.ok((Object)sb.toString()).build();
    }
}

