/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter;

import ee.jakarta.tck.ws.rs.common.AbstractMessageBodyRW;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.EntityAnnotation;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.ReadableWritableEntity;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Provider
public class EntityMessageReader
extends AbstractMessageBodyRW
implements MessageBodyReader<ReadableWritableEntity> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String path = EntityMessageReader.getSpecifiedAnnotationValue(annotations, EntityAnnotation.class);
        if (path == null) {
            return false;
        }
        path = path.toLowerCase();
        boolean readable = path.contains("body");
        readable |= path.contains("head");
        readable |= path.contains("ioexception");
        readable |= path.contains("webexception");
        readable &= MediaType.TEXT_XML_TYPE.isCompatible(mediaType);
        return readable &= ReadableWritableEntity.class.isAssignableFrom(type);
    }

    public ReadableWritableEntity readFrom(Class<ReadableWritableEntity> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String ea = EntityMessageReader.getSpecifiedAnnotationValue(annotations, EntityAnnotation.class).toLowerCase();
        String entity = "null";
        if (ea.contains("body")) {
            entity = this.readInputStream(entityStream);
        } else if (ea.contains("head")) {
            entity = (String)httpHeaders.getFirst((Object)"READABLEWRITEABLE");
        } else {
            if (ea.contains("ioexception")) {
                throw new IOException("CTS test IOException");
            }
            if (ea.contains("webexception")) {
                entity = (String)httpHeaders.getFirst((Object)"READABLEWRITEABLE");
                throw new WebApplicationException(Response.Status.valueOf((String)entity));
            }
        }
        return ReadableWritableEntity.fromString(entity);
    }

    String readInputStream(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        return br.readLine();
    }
}

