/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.jaxbcontext;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.jaxbcontext.JaxbContextProvider;
import ee.jakarta.tck.ws.rs.spec.provider.jaxbcontext.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.jaxbcontext.SomeJaxbContext;
import ee.jakarta.tck.ws.rs.spec.provider.jaxbcontext.SomeMarshaller;
import ee.jakarta.tck.ws.rs.spec.provider.jaxbcontext.SomeUnmarshaller;
import ee.jakarta.tck.ws.rs.spec.provider.jaxbcontext.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.provider.jaxbcontext.TckJaxbProvider;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_jaxbcontext_web/resource");
    }

    private void setPropertyAndInvoke(String resourceMethod) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, resourceMethod));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SomeUnmarshaller.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SomeMarshaller.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "anything");
        this.invoke();
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/jaxbcontext/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_jaxbcontext_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, JaxbContextProvider.class, SomeJaxbContext.class, SomeMarshaller.class, SomeUnmarshaller.class, TckJaxbProvider.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    @Tag(value="xml_binding")
    public void readWriteProviderTest() throws JAXRSCommonClient.Fault {
        this.setPropertyAndInvoke("jaxb");
    }
}

