/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.responsebuilder;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.core.responsebuilder.AnnotatedClass;
import ee.jakarta.tck.ws.rs.ee.rs.core.responsebuilder.DateClientReaderWriter;
import ee.jakarta.tck.ws.rs.ee.rs.core.responsebuilder.DateContainerReaderWriter;
import ee.jakarta.tck.ws.rs.ee.rs.core.responsebuilder.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.core.responsebuilder.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.Calendar;
import java.util.Date;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_core_responsebuilder_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/core/responsebuilder/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_core_responsebuilder_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, AnnotatedClass.class, DateContainerReaderWriter.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void entityObjectTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations;
        Date date = Calendar.getInstance().getTime();
        String entity = DateContainerReaderWriter.dateToString(date);
        StringBuilder sb = new StringBuilder();
        DateClientReaderWriter rw = new DateClientReaderWriter(sb);
        this.addProvider(rw);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "entity"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, entity);
        this.invoke();
        Response response = this.getResponse();
        Date responseDate = (Date)response.readEntity(Date.class);
        Assertions.assertTrue((boolean)date.equals(responseDate), (String)("entity date" + date + "differs from acquired" + responseDate));
        for (Annotation annotation : annotations = AnnotatedClass.class.getAnnotations()) {
            String name = annotation.annotationType().getName();
            Assertions.assertTrue((boolean)sb.toString().contains(name), (String)(sb + "does not contain" + name + ", annotations not passed to MessageBodyWriter?"));
        }
    }

    protected <T> GenericType<T> generic(Class<T> clazz) {
        return new GenericType(clazz);
    }

    protected String readLine(Reader reader) throws JAXRSCommonClient.Fault {
        String line = null;
        BufferedReader buffered = new BufferedReader(reader);
        try {
            line = buffered.readLine();
        }
        catch (IOException e) {
            try {
                buffered.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new JAXRSCommonClient.Fault(e);
        }
        return line;
    }
}

