/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.servererrorexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -143670490120851422L;
    public static final Response.Status.Family FAMILY = Response.Status.Family.SERVER_ERROR;
    protected static final String MESSAGE = "TCK ServerErrorException description";
    protected static final String HOST = "www.jcp.org";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorStatusTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            ServerErrorException e = new ServerErrorException(status);
            JAXRSClientIT.assertResponse((WebApplicationException)e, status);
        }
    }

    @Test
    public void constructorStatusThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(status);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStatusNullThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            ServerErrorException e = new ServerErrorException((Response.Status)null);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for null status", "; exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null status");
        }
    }

    @Test
    public void constructorIntTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            ServerErrorException e = new ServerErrorException(status.getStatusCode());
            JAXRSClientIT.assertResponse((WebApplicationException)e, status);
        }
    }

    @Test
    public void constructorIntThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(status.getStatusCode());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorIntNotValidStatusThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (int status : new int[]{-1, Integer.MAX_VALUE, Integer.MIN_VALUE}) {
            try {
                ServerErrorException e = new ServerErrorException(status);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorResponseTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            ServerErrorException e = new ServerErrorException(this.buildResponse(status));
            this.assertResponse((WebApplicationException)e, status, HOST);
        }
    }

    @Test
    public void constructorResponseThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStatusThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            for (Throwable throwable : throwables) {
                ServerErrorException e = new ServerErrorException(status, throwable);
                JAXRSClientIT.assertResponse((WebApplicationException)e, status);
                this.assertCause((WebApplicationException)e, throwable);
            }
        }
    }

    @Test
    public void constructorStatusThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        Throwable throwable = new Throwable();
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(status, throwable);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStatusNullThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        Throwable throwable = new Throwable();
        try {
            ServerErrorException e = new ServerErrorException((Response.Status)null, throwable);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for null status", "; exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null status");
        }
    }

    @Test
    public void constructorIntThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            for (Throwable throwable : throwables) {
                ServerErrorException e = new ServerErrorException(status.getStatusCode(), throwable);
                JAXRSClientIT.assertResponse((WebApplicationException)e, status);
                this.assertCause((WebApplicationException)e, throwable);
            }
        }
    }

    @Test
    public void constructorIntThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        Throwable throwable = new Throwable();
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(status.getStatusCode(), throwable);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorIntNotValidStatusThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        Throwable throwable = new Throwable();
        for (int status : new int[]{-1, Integer.MAX_VALUE, Integer.MIN_VALUE}) {
            try {
                ServerErrorException e = new ServerErrorException(status, throwable);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            for (Throwable throwable : throwables) {
                ServerErrorException e = new ServerErrorException(this.buildResponse(status), throwable);
                this.assertResponse((WebApplicationException)e, status, HOST);
                this.assertCause((WebApplicationException)e, throwable);
            }
        }
    }

    @Test
    public void constructorResponseThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        Throwable throwable = new Throwable();
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(this.buildResponse(status), throwable);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringStatusTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            ServerErrorException e = new ServerErrorException(MESSAGE, status);
            JAXRSClientIT.assertResponse((WebApplicationException)e, status);
            this.assertMessage((WebApplicationException)e);
        }
    }

    @Test
    public void constructorStringStatusThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(MESSAGE, status);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringStatusNullThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            ServerErrorException e = new ServerErrorException(MESSAGE, (Response.Status)null);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for null status", "; exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null status");
        }
    }

    @Test
    public void constructorStringIntTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            ServerErrorException e = new ServerErrorException(MESSAGE, status.getStatusCode());
            JAXRSClientIT.assertResponse((WebApplicationException)e, status);
            this.assertMessage((WebApplicationException)e);
        }
    }

    @Test
    public void constructorStringIntThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(MESSAGE, status.getStatusCode());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringIntNotValidStatusThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (int status : new int[]{-1, Integer.MAX_VALUE, Integer.MIN_VALUE}) {
            try {
                ServerErrorException e = new ServerErrorException(MESSAGE, status);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringResponseTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            ServerErrorException e = new ServerErrorException(MESSAGE, this.buildResponse(status));
            this.assertResponse((WebApplicationException)e, status, HOST);
            this.assertMessage((WebApplicationException)e);
        }
    }

    @Test
    public void constructorStringResponseThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(MESSAGE, this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringStatusThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            for (Throwable throwable : throwables) {
                ServerErrorException e = new ServerErrorException(MESSAGE, status, throwable);
                JAXRSClientIT.assertResponse((WebApplicationException)e, status);
                this.assertCause((WebApplicationException)e, throwable);
                this.assertMessage((WebApplicationException)e);
            }
        }
    }

    @Test
    public void constructorStringStatusThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        Throwable throwable = new Throwable();
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(MESSAGE, status, throwable);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringStatusNullThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        Throwable throwable = new Throwable();
        try {
            ServerErrorException e = new ServerErrorException(MESSAGE, (Response.Status)null, throwable);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for null status", "; exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null status");
        }
    }

    @Test
    public void constructorStringIntThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            for (Throwable throwable : throwables) {
                ServerErrorException e = new ServerErrorException(MESSAGE, status.getStatusCode(), throwable);
                JAXRSClientIT.assertResponse((WebApplicationException)e, status);
                this.assertCause((WebApplicationException)e, throwable);
                this.assertMessage((WebApplicationException)e);
            }
        }
    }

    @Test
    public void constructorStringIntThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        Throwable throwable = new Throwable();
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(MESSAGE, status.getStatusCode(), throwable);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringIntNotValidStatusThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        Throwable throwable = new Throwable();
        for (int status : new int[]{-1, Integer.MAX_VALUE, Integer.MIN_VALUE}) {
            try {
                ServerErrorException e = new ServerErrorException(MESSAGE, status, throwable);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            for (Throwable throwable : throwables) {
                ServerErrorException e = new ServerErrorException(MESSAGE, this.buildResponse(status), throwable);
                this.assertResponse((WebApplicationException)e, status, HOST);
                this.assertCause((WebApplicationException)e, throwable);
                this.assertMessage((WebApplicationException)e);
            }
        }
    }

    @Test
    public void constructorStringResponseThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        Throwable throwable = new Throwable();
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                ServerErrorException e = new ServerErrorException(MESSAGE, this.buildResponse(status), throwable);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    protected Response buildResponse(Response.Status status) {
        return Response.status((Response.Status)status).header("Host", (Object)HOST).build();
    }

    protected static void assertResponse(WebApplicationException e, Response.Status status) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "#getResponse is null");
        Response response = e.getResponse();
        JAXRSClientIT.assertEqualsInt(response.getStatus(), status.getStatusCode(), "response contains unexpected status", response.getStatus());
        JAXRSClientIT.logMsg("response contains expected", status, "status");
    }

    protected void assertResponse(WebApplicationException e, Response.Status status, String host) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertResponse(e, status);
        String header = e.getResponse().getHeaderString("Host");
        JAXRSClientIT.assertNotNull(header, "http header", "Host", " of response is null");
        JAXRSClientIT.assertEquals(host, header, "Found unexpected http", "Host", "header", header);
        JAXRSClientIT.logMsg("Found expected http", "Host", "header");
    }

    protected void assertCause(WebApplicationException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(e.getCause(), expected, "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }

    protected static List<Response.Status> getStatusesFromFamily() {
        LinkedList<Response.Status> list = new LinkedList<Response.Status>();
        for (Response.Status status : Response.Status.values()) {
            if (!Response.Status.Family.familyOf((int)status.getStatusCode()).equals((Object)FAMILY)) continue;
            list.add(status);
        }
        return list;
    }

    protected static List<Response.Status> getStatusesOutsideFamily() {
        LinkedList<Response.Status> list = new LinkedList<Response.Status>();
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()).equals((Object)FAMILY)) continue;
            list.add(status);
        }
        return list;
    }

    protected void assertMessage(WebApplicationException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "getMessage() is null");
        JAXRSClientIT.assertContains(e.getMessage(), MESSAGE, new Object[]{"Unexpected getMessage()", e.getMessage()});
        JAXRSClientIT.logMsg("found expected getMessage()=", e.getMessage());
    }
}

