/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._float.whitespace.whitespace_1;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import jakarta.xml.bind.JAXBException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class whiteSpace1_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        whiteSpace1_ValidateCTTests test = new whiteSpace1_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final float[] validValues = {0.0F, 1.0F, -1.0F, Float.MAX_VALUE
                                , Float.NEGATIVE_INFINITY, Float.NaN};
    
    JAXBElement<Float> elemObj;

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Unmarshalled001( ) {
        elemObj = (JAXBElement<Float>)unmarshal("whiteSpace-1-1.xml");
        return testValid();
    }

    public Status Created001( ) {
        elemObj = (JAXBElement<Float>)(new ObjectFactory()).createNISTSchemaFloatWhiteSpace1(validValues[0]);
        
        return testValid();
    }


}

