/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.api.jakarta.websocket.websocketcontainer;

import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Extension;
import jakarta.websocket.WebSocketContainer;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class WSClientIT {
    private static final System.Logger logger = System.getLogger(WSClientIT.class.getName());

    @Test
    public void getMaxSessionIdleTimeoutTest() throws Exception {
        WebSocketContainer client = ContainerProvider.getWebSocketContainer();
        if (client.getDefaultMaxSessionIdleTimeout() != 0L) {
            logger.log(System.Logger.Level.TRACE, "Default timeout is: " + client.getDefaultMaxSessionIdleTimeout());
        }
    }

    @Test
    public void setMaxSessionIdleTimeoutTest() throws Exception {
        long timeout = 987654321L;
        WebSocketContainer client = ContainerProvider.getWebSocketContainer();
        client.setDefaultMaxSessionIdleTimeout(timeout);
        if (client.getDefaultMaxSessionIdleTimeout() != timeout) {
            throw new Exception("Test failed. getMaxSessionIdleTimeout didn't return set value.Expecting " + timeout + "; got " + client.getDefaultMaxSessionIdleTimeout());
        }
    }

    @Test
    public void getMaxTextMessageBufferSizeTest() throws Exception {
        WebSocketContainer client = ContainerProvider.getWebSocketContainer();
        long default_msgsize = client.getDefaultMaxTextMessageBufferSize();
        logger.log(System.Logger.Level.INFO, "Default MaxTextMessageBufferSize is " + default_msgsize);
    }

    @Test
    public void setMaxTextMessageBufferSizeTest() throws Exception {
        int expected_msgsize = 987654321;
        WebSocketContainer client = ContainerProvider.getWebSocketContainer();
        long default_msgsize = client.getDefaultMaxTextMessageBufferSize();
        logger.log(System.Logger.Level.INFO, "Default MaxTextMessageBufferSize is " + default_msgsize);
        client.setDefaultMaxTextMessageBufferSize(expected_msgsize);
        long actual_msgsize = client.getDefaultMaxTextMessageBufferSize();
        if ((long)expected_msgsize != actual_msgsize) {
            throw new Exception("DefaultMaxTextMessageBufferSize does not match. Expecting " + expected_msgsize + ", got " + actual_msgsize);
        }
    }

    @Test
    public void getMaxBinaryMessageBufferSizeTest() throws Exception {
        WebSocketContainer client = ContainerProvider.getWebSocketContainer();
        long default_msgsize = client.getDefaultMaxBinaryMessageBufferSize();
        logger.log(System.Logger.Level.INFO, "Default MaxTextMessageBufferSize is " + default_msgsize);
    }

    @Test
    public void setMaxBinaryMessageBufferSizeTest() throws Exception {
        int expected_msgsize = 987654321;
        WebSocketContainer client = ContainerProvider.getWebSocketContainer();
        long default_msgsize = client.getDefaultMaxBinaryMessageBufferSize();
        logger.log(System.Logger.Level.INFO, "Default MaxBinaryMessageBufferSize is " + default_msgsize);
        client.setDefaultMaxBinaryMessageBufferSize(expected_msgsize);
        long actual_msgsize = client.getDefaultMaxBinaryMessageBufferSize();
        if ((long)expected_msgsize != actual_msgsize) {
            throw new Exception("DefaultMaxBinaryMessageBufferSize does not match. Expecting " + expected_msgsize + ", got " + actual_msgsize);
        }
    }

    @Test
    public void getDefaultAsyncSendTimeoutTest() throws Exception {
        WebSocketContainer client = ContainerProvider.getWebSocketContainer();
        if (client.getDefaultAsyncSendTimeout() != 0L) {
            logger.log(System.Logger.Level.TRACE, "Default timeout is: " + client.getDefaultMaxSessionIdleTimeout());
        }
    }

    @Test
    public void setAsyncSendTimeoutTest() throws Exception {
        long expected_timeout = 987654321L;
        WebSocketContainer client = ContainerProvider.getWebSocketContainer();
        client.setAsyncSendTimeout(expected_timeout);
        long actual_timeout = client.getDefaultAsyncSendTimeout();
        if (actual_timeout != expected_timeout) {
            throw new Exception("Test failed. getDefaultAsyncSendTimeout didn't return set value.Expecting " + expected_timeout + "; got " + actual_timeout);
        }
    }

    @Test
    public void getInstalledExtensionsTest() throws Exception {
        WebSocketContainer client = ContainerProvider.getWebSocketContainer();
        Set extensions = client.getInstalledExtensions();
        if (extensions != null) {
            if (!extensions.isEmpty()) {
                for (Extension tmp : extensions) {
                    logger.log(System.Logger.Level.INFO, "Installed Extension: " + tmp.getName());
                    List params = tmp.getParameters();
                    for (Extension.Parameter tmp1 : params) {
                        logger.log(System.Logger.Level.INFO, "Parameter's name= " + tmp1.getName() + "Parameter's value= " + tmp1.getValue());
                    }
                }
            } else {
                logger.log(System.Logger.Level.INFO, "Installed Extension returned empty set");
            }
        } else {
            logger.log(System.Logger.Level.INFO, "getInstalledExtensions() returned null");
        }
    }

    public void cleanup() {
    }
}

