/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.sessionexception;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.MessageValidator;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.sessionexception.WSTestServer;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.SessionException;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final System.Logger logger = System.getLogger(WSClientIT.class.getName());
    private static final String CONTEXT_ROOT = "/ws_sessionexception_web";
    private static final String SENT_STRING_MESSAGE = "Hello World in String";
    private static StringBuffer receivedMessageString = new StringBuffer();
    static CountDownLatch messageLatch;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ws_sessionexception_web.war");
        archive.addClass(WSTestServer.class);
        archive.addAsWebInfResource(WSClientIT.class.getPackage(), "web.xml", "web.xml");
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("ws_sessionexception_web");
    }

    @Test
    public void test1() throws Exception {
        boolean passed = true;
        String message_expected = "TCKTest";
        String message_sent_string = "SessionException test";
        try {
            Throwable cause;
            String msg;
            messageLatch = new CountDownLatch(5);
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            Session session = clientContainer.connectToServer(TCKBasicEndpoint.class, config, new URI("ws://" + this._hostname + ":" + this._port + "/ws_sessionexception_web/TCKTestServer"));
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            receivedMessageString.append("========Just setup to get a  real working session");
            session.getBasicRemote().sendText(message_sent_string);
            messageLatch.await(this._ws_wait, TimeUnit.SECONDS);
            Throwable cause_expected = new Throwable(message_expected + "1");
            SessionException ex = new SessionException(message_expected, new Throwable(cause_expected), session);
            Session tmp = ex.getSession();
            if (tmp != session) {
                passed = false;
                receivedMessageString.append("========Incorrect session returned,  expecting " + session + ", got " + tmp);
            }
            if (!message_expected.equals(msg = ex.getMessage())) {
                passed = false;
                receivedMessageString.append("========Incorrect message returned,  expecting " + message_expected + ", got " + msg);
            }
            if ((cause = ex.getCause()).getCause() != null) {
                cause = cause.getCause();
            } else {
                passed = false;
                receivedMessageString.append("Lost one wrap of Throwable during the process");
            }
            if (cause_expected != cause) {
                passed = false;
                receivedMessageString.append("========Incorrect cause returned,  expecting " + cause_expected + ", got " + cause);
            }
            session.close();
            Boolean passed_tmp = MessageValidator.checkSearchStrings("TCKTestServer opened|TCKTestServer received String:|" + message_sent_string + "|TCKTestServer responds, please close your session", receivedMessageString.toString());
            if (!passed_tmp.booleanValue()) {
                passed = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            passed = false;
            receivedMessageString.append("========unexpected Exception caught");
        }
        logger.log(System.Logger.Level.INFO, receivedMessageString.toString());
        if (!passed) {
            throw new Exception("Test failed with incorrect response");
        }
    }

    @Override
    public void cleanup() throws Exception {
        super.cleanup();
    }

    public static final class TCKBasicEndpoint
    extends Endpoint {
        public void onOpen(Session session, EndpointConfig config) {
            session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    receivedMessageString.append(message);
                    messageLatch.countDown();
                }
            });
        }

        public void onClose(Session session, CloseReason closeReason) {
            receivedMessageString.append("CloseCode=" + closeReason.getCloseCode());
            receivedMessageString.append("ReasonPhrase=" + closeReason.getReasonPhrase());
        }
    }
}

