/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core.reference;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.impl.SecurityHeaderException;
import com.sun.xml.wss.impl.misc.Base64;
import java.util.logging.Level;
import javax.xml.soap.SOAPElement;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.w3c.dom.Document;

public class EncryptedKeySHA1Identifier
extends KeyIdentifier {
    private String encodingType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private String valueType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1";

    public EncryptedKeySHA1Identifier(Document doc) throws XWSSecurityException {
        super(doc);
        this.setAttribute("EncodingType", this.encodingType);
        this.setAttribute("ValueType", this.valueType);
    }

    public EncryptedKeySHA1Identifier(SOAPElement element) throws XWSSecurityException {
        super(element);
    }

    public byte[] getDecodedBase64EncodedValue() throws XWSSecurityException {
        try {
            return Base64.decode(this.getReferenceValue());
        }
        catch (Base64DecodingException e) {
            log.log(Level.SEVERE, "WSS0144.unableto.decode.base64.data", new Object[]{e.getMessage()});
            throw new SecurityHeaderException("Unable to decode Base64 encoded data", e);
        }
    }
}

